/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.storage;

public enum ColumnType {
    INTEGER("INT"),
    FLOAT("FLOAT"),
    LONG("LONG"),
    TEXT("TEXT"),
    VARCHAR("VARCHAR(255)"),
    VARCHAR_UUID("VARCHAR(37)"),
    VARCHAR_64("VARCHAR(64)"),
    DOUBLE("DOUBLE"),
    BOOLEAN("BOOLEAN");

    private final String sql;

    private ColumnType(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public static ColumnType matchType(String s) {
        for (ColumnType c : ColumnType.values()) {
            if (c.getSql().equalsIgnoreCase(s)) {
                return c;
            }
            if (!c.getSql().split("\\(")[0].equalsIgnoreCase(s)) continue;
            return c;
        }
        return null;
    }

    public boolean isVarchar() {
        return this.equals((Object)VARCHAR) || this.equals((Object)VARCHAR_UUID) || this.equals((Object)VARCHAR_64);
    }

    public static boolean isSimilarMatching(ColumnType type1, ColumnType type2) {
        if (type1.getSql().contains("VARCHAR") && type2.getSql().contains("VARCHAR")) {
            return true;
        }
        return type1.getSql().equalsIgnoreCase(type2.getSql());
    }
}

