/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import io.aquaticlabs.aquaticdata.data.object.DataObject;
import io.aquaticlabs.aquaticdata.data.storage.Storage;
import io.aquaticlabs.aquaticdata.util.DataDebugLog;
import java.util.concurrent.TimeUnit;

public class ObjectCache {
    private Storage<?> holder;
    private LoadingCache<Object, DataObject> objectCache;

    public ObjectCache(Storage<?> holder, long amount, TimeUnit unit) {
        this.holder = holder;
        CacheLoader<Object, DataObject> cache = new CacheLoader<Object, DataObject>(){

            public DataObject load(Object key) {
                return null;
            }
        };
        this.objectCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(amount, unit).removalListener(this.defaultRemovalListener()).build((CacheLoader)cache);
    }

    private RemovalListener<Object, DataObject> defaultRemovalListener() {
        return notification -> {
            DataDebugLog.logDebug("Going to remove data from InputDataPool");
            if (notification.getCause() == RemovalCause.EXPIRED) {
                DataDebugLog.logDebug("This data expired: " + notification.getKey());
                this.holder.removeDataObj((DataObject)notification.getValue());
            } else {
                DataDebugLog.logDebug("This data was manually removed: " + notification.getKey());
            }
        };
    }

    public LoadingCache<Object, DataObject> getObjectCache() {
        return this.objectCache;
    }
}

