/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data;

import io.aquaticlabs.aquaticdata.data.HikariCPDatabase;
import io.aquaticlabs.aquaticdata.data.object.DataEntry;
import io.aquaticlabs.aquaticdata.data.storage.ColumnType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ADatabase {
    private final String table;

    protected ADatabase(String table) {
        this.table = table;
    }

    public abstract <T> T executeConnection(HikariCPDatabase.ConnectionCallback<T> var1);

    public abstract <T> T executeNonLockConnection(HikariCPDatabase.ConnectionCallback<T> var1);

    public abstract void evict(Connection var1);

    public abstract void shutdown();

    public abstract String insertStatement(List<DataEntry<String, String>> var1);

    public abstract String buildUpdateStatementSQL(List<DataEntry<String, String>> var1);

    public abstract void createTable(List<DataEntry<String, ColumnType>> var1, boolean var2);

    public String getSQLiteVersion() {
        AtomicReference<String> version = new AtomicReference<String>("");
        String selectSQLiteVersion = "SELECT sqlite_version()";
        this.executeConnection(conn -> {
            PreparedStatement statement = conn.prepareStatement("SELECT sqlite_version()");
            ResultSet resultSet = statement.executeQuery();
            version.set(resultSet.getString(1));
            return resultSet.getString(1);
        });
        return version.get();
    }

    public String getTable() {
        return this.table;
    }
}

