/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata;

import java.util.function.Consumer;
import java.util.logging.Logger;
import lombok.NonNull;

public class AquaticDatabase {
    private static AquaticDatabase instance;
    private Logger logger;
    private boolean debug = false;
    private Consumer<Runnable> asyncRunner;
    private Consumer<Runnable> syncRunner = Runnable::run;

    public AquaticDatabase(@NonNull Consumer<Runnable> asyncRunner, @NonNull Consumer<Runnable> syncRunner, boolean debug, Logger logger) {
        if (asyncRunner == null) {
            throw new NullPointerException("asyncRunner is marked non-null but is null");
        }
        if (syncRunner == null) {
            throw new NullPointerException("syncRunner is marked non-null but is null");
        }
        if (instance != null) {
            System.out.println("Already an Instance of DataLib");
            return;
        }
        instance = this;
        this.logger = logger;
        this.debug = debug;
        this.asyncRunner = asyncRunner;
        this.syncRunner = syncRunner;
    }

    public Consumer<Runnable> getRunner(boolean async) {
        return async ? this.asyncRunner : this.syncRunner;
    }

    public static AquaticDatabase getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

