/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.utils.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.utils.files.ConfigFile;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileUtil {
    private StatsSB plugin;
    private FileConfiguration custom = null;
    private File customFile = null;
    private ConfigFile configFile;

    public FileUtil(StatsSB plugin) {
        this.plugin = plugin;
    }

    public void setupConfig(String fileName) {
        this.customFile = new File(this.plugin.getDataFolder(), fileName + ".yml");
        this.custom = new YamlConfiguration();
        if (!this.customFile.exists()) {
            this.customFile.getParentFile().mkdirs();
            try {
                this.customFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.copy(this.plugin.getResource(fileName + ".yml"), this.customFile);
            this.loadConfig(fileName);
            this.loadSettingFile(fileName);
        } else {
            this.mergeConfig(fileName);
        }
    }

    private void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadConfig(String fileName) {
        if (this.customFile == null) {
            this.customFile = new File(this.plugin.getDataFolder(), fileName + ".yml");
        }
        this.custom = YamlConfiguration.loadConfiguration((File)this.customFile);
    }

    public void loadSettingFile(String fileName) {
        if (fileName.equals("config")) {
            this.setConfigFile(new ConfigFile(this.plugin, this.customFile, this.custom));
        }
    }

    public void reloadConfig(String fileName) {
        this.loadConfig(fileName);
        this.loadSettingFile(fileName);
    }

    private void mergeConfig(String fileName) {
        try {
            this.loadConfig(fileName);
            YamlConfiguration newConfig = new YamlConfiguration();
            InputStreamReader defConfigStream = new InputStreamReader(this.plugin.getResource(fileName + ".yml"), StandardCharsets.UTF_8);
            newConfig.load((Reader)defConfigStream);
            ArrayList<String> currentEntries = this.getAllEntries(this.custom);
            ArrayList<String> newEntries = this.getAllEntries((FileConfiguration)newConfig);
            for (String s : newEntries) {
                if (currentEntries.contains(s)) continue;
                this.custom.set(s, newConfig.get(s));
            }
            this.custom.save(this.customFile);
            this.reloadConfig(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getAllEntries(FileConfiguration custom) {
        ArrayList<String> entries = new ArrayList<String>();
        Map contents = custom.getValues(true);
        for (String s : contents.keySet()) {
            if (s == null) continue;
            entries.add(s);
        }
        return entries;
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(ConfigFile configFile) {
        this.configFile = configFile;
    }
}

