/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.leaderboards.Leaderboard;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.MathUtil;
import me.extremesnow.statssb.utils.files.ConfigFile;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Utilities {
    private static final Pattern HEX_REGEX = Pattern.compile("#[0-9A-Fa-f]{6}|#[0-9A-Fa-f]{3}");

    public static Map<PlayerData, Integer> sortItems(Map<PlayerData, Integer> items) {
        LinkedHashMap<PlayerData, Integer> sortedItems = new LinkedHashMap<PlayerData, Integer>();
        items.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(x -> {
            Integer cfr_ignored_0 = (Integer)sortedItems.put((PlayerData)x.getKey(), (Integer)x.getValue());
        });
        return sortedItems;
    }

    public static String plural(Object value, String type) {
        boolean bool = false;
        if (value.equals(1) || value.equals(1.0)) {
            bool = true;
        }
        return bool ? " " + type : " " + type + "s";
    }

    public static String getLBTitle(StatsSB plugin, StatType type) {
        ConfigFile configFile = plugin.getFileUtil().getConfigFile();
        if (type == StatType.DEATH) {
            return configFile.getLeaderboardDeathsTitle();
        }
        return configFile.getLeaderboardKillsTitle();
    }

    public static String removeLastChar(String s) {
        return s == null || s.length() == 0 ? "" : s.substring(0, s.length() - 1);
    }

    public static void reloadBoard(StatsSB plugin, StatType statType) {
        CompletableFuture.runAsync(() -> plugin.getLeaderboards().get((Object)statType).build());
    }

    public static void errorMessage(Exception e, String s) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_RED + "ERROR: " + ChatColor.AQUA + s);
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "Contact Developer - ");
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "-----------------------------------");
        e.printStackTrace();
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "-----------------------------------");
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
    }

    public static void errorMessage(String s) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_RED + "ERROR: " + ChatColor.AQUA + s);
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "Contact Developer - ");
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + "-----------------------------------");
    }

    public static void saveFile(File file, FileConfiguration fileConfiguration) {
        try {
            fileConfiguration.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateStats(final StatsSB plugin) {
        if (plugin.getFileUtil().getConfigFile().getConfig().getBoolean("database.bungee")) {
            new BukkitRunnable(){

                public void run() {
                    plugin.getPlayerDataHolder().load();
                }
            }.runTaskTimer((Plugin)plugin, 10L, 400L);
        }
    }

    public static boolean containsString(String string, List<String> list) {
        String listString = list.toString().replace("[", "").replace("]", "");
        String[] strings = listString.split(",");
        boolean contains = false;
        for (String s : strings) {
            if (!s.equalsIgnoreCase(string)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static String replacePlaceholders(StatsSB plugin, PlayerData playerData, String string) {
        SimpleDateFormat date;
        ConfigFile configFile = plugin.getFileUtil().getConfigFile();
        String dateTimeZone = plugin.getConfig().getString("Scoreboard.dateTimeZone");
        Date now = new Date();
        try {
            date = new SimpleDateFormat(configFile.getDateFormat());
        }
        catch (NullPointerException e) {
            date = new SimpleDateFormat("MM/dd/yyyy");
        }
        date.setTimeZone(TimeZone.getTimeZone(dateTimeZone));
        string = playerData.replacePlaceholders(string).replace("%date%", date.format(now)).replace("%blank-1%", ChatColor.RESET.toString() + "").replace("%blank-2%", ChatColor.RESET.toString() + "" + ChatColor.RESET.toString()).replace("%blank-3%", ChatColor.RESET.toString() + " ").replace("%blank-4%", ChatColor.RESET.toString() + "  ").replace("%blank-5%", ChatColor.RESET.toString() + "   ").replace("%blank-6%", ChatColor.RESET.toString() + "    ").replace("&", "\u00a7");
        if (configFile.isEconomyEnabled() && plugin.getServer().getPluginManager().getPlugin("Vault") != null) {
            OfflinePlayer offlinePlayer;
            Economy econ = plugin.getEconomy();
            String balance = MathUtil.isInt(econ.getBalance(offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerData.getUuid()))) ? MathUtil.getInt(econ.getBalance((OfflinePlayer)Bukkit.getPlayer((UUID)playerData.getUuid()))) + "" : MathUtil.roundTwoDecimals(econ.getBalance(offlinePlayer)) + "";
            string = string.replace("%money%", balance);
        }
        if (plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            string = PlaceholderAPI.setPlaceholders((Player)Bukkit.getPlayer((UUID)playerData.getUuid()), (String)string);
        }
        return string;
    }

    public static String replacePlaceholders(StatsSB plugin, PlayerData playerData, String string, boolean t) {
        SimpleDateFormat date;
        ConfigFile configFile = plugin.getFileUtil().getConfigFile();
        String dateTimeZone = plugin.getConfig().getString("Scoreboard.dateTimeZone");
        Date now = new Date();
        try {
            date = new SimpleDateFormat(configFile.getDateFormat());
        }
        catch (NullPointerException e) {
            date = new SimpleDateFormat("MM/dd/yyyy");
        }
        date.setTimeZone(TimeZone.getTimeZone(dateTimeZone));
        string = string.replace("%date%", date.format(now)).replace("%blank-1%", ChatColor.RESET.toString() + "").replace("%blank-2%", ChatColor.RESET.toString() + "" + ChatColor.RESET.toString()).replace("%blank-3%", ChatColor.RESET.toString() + " ").replace("%blank-4%", ChatColor.RESET.toString() + "  ").replace("%blank-5%", ChatColor.RESET.toString() + "   ").replace("%blank-6%", ChatColor.RESET.toString() + "    ").replace("&", "\u00a7");
        if (configFile.isEconomyEnabled() && plugin.getServer().getPluginManager().getPlugin("Vault") != null) {
            OfflinePlayer offlinePlayer;
            Economy econ = plugin.getEconomy();
            String balance = MathUtil.isInt(econ.getBalance(offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerData.getUuid()))) ? MathUtil.getInt(econ.getBalance((OfflinePlayer)Bukkit.getPlayer((UUID)playerData.getUuid()))) + "" : MathUtil.roundTwoDecimals(econ.getBalance(offlinePlayer)) + "";
            string = string.replace("%money%", balance);
        }
        if (plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            string = PlaceholderAPI.setPlaceholders((Player)Bukkit.getPlayer((UUID)playerData.getUuid()), (String)string);
        }
        return string;
    }

    public static String replaceColorCodes(String input) {
        return input.replace("&", "\u00a7");
    }

    public static void addToPlayerMaps(StatsSB plugin, PlayerData playerData) {
        for (Leaderboard leaderboard : plugin.getLeaderboards().values()) {
            if (leaderboard.getStatType().getType() == Double.TYPE) {
                leaderboard.addPlayer(playerData, 0.0);
                continue;
            }
            leaderboard.addPlayer(playerData, 0);
        }
    }

    public static boolean checkEnabledLocation(StatsSB plugin, Player player) {
        ConfigFile configFile = plugin.getFileUtil().getConfigFile();
        return !configFile.isDisableCertainWorlds() || Utilities.containsString(player.getWorld().getName(), configFile.getEnabledWorlds());
    }
}

