/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.utils;

import java.io.File;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import me.extremesnow.datalib.data.AbstractSQL;
import me.extremesnow.datalib.data.SQLCredential;
import me.extremesnow.datalib.data.sqlite.old.SQLiteOldCredential;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.data.PlayerDataHolder;
import me.extremesnow.statssb.utils.DebugLogger;

public class FileConverter {
    private final StatsSB plugin;
    private final SQLCredential credential;
    private PlayerDataHolder newHolder;
    private PlayerDataHolder holder;
    private boolean liteTransfer;
    private boolean completed = false;

    public FileConverter(StatsSB plugin, PlayerDataHolder newHolder, SQLCredential credential) {
        this(plugin, newHolder, credential, false);
    }

    public FileConverter(StatsSB plugin, PlayerDataHolder newHolder, SQLCredential credential, boolean liteTransfer) {
        this.plugin = plugin;
        this.credential = credential;
        this.newHolder = newHolder;
        this.liteTransfer = liteTransfer;
        if (credential instanceof SQLiteOldCredential) {
            this.convertSQLite();
        } else {
            this.convertMySQL();
        }
    }

    public void convertSQLite() {
        AbstractSQL data = this.credential.build();
        if (data.getColumns().size() < 8) {
            this.liteTransfer = true;
            this.credential.setNeedsSpecialTreatment(true);
            data.shutdown();
        }
        data.shutdown();
        this.holder = new PlayerDataHolder(this.plugin, this.credential);
        CompletableFuture.runAsync(() -> {
            long loadStart = System.currentTimeMillis();
            for (PlayerData oldData : this.holder.getAllPlayerDatas()) {
                this.newHolder.getData().putIfAbsent(oldData.getUuid(), oldData);
            }
            this.newHolder.save(true);
            long loadEnd = System.currentTimeMillis();
            long loadElapsedTime = loadEnd - loadStart;
            this.holder.getDatabase().shutdown();
            this.holder = null;
            boolean deleted = new File(this.plugin.getDataFolder(), "player_stats.db").delete();
            boolean deleted2 = new File(this.plugin.getDataFolder(), "stats.db").delete();
            if (deleted) {
                DebugLogger.logDebugMessage("Old player_stats.db File Deleted.");
            }
            if (deleted2) {
                DebugLogger.logDebugMessage("Old stats.db File Deleted.");
            }
            DebugLogger.logDebugMessage("Data Converting time: " + loadElapsedTime + "ms");
            DebugLogger.logDebugMessage("Converted " + this.holder.getAllPlayerDatas().size() + " users.");
        }).whenComplete((t, s) -> {
            this.completed = true;
        });
    }

    public void convertMySQL() {
        AbstractSQL data = this.credential.build();
        if (!data.getTables().contains("stats")) {
            DebugLogger.logDebugMessage("DOESNT CONTAIN STATS");
            data.shutdown();
            return;
        }
        if (data.getColumns().size() < 8) {
            this.liteTransfer = true;
            this.credential.setNeedsSpecialTreatment(true);
            data.shutdown();
        }
        this.holder = new PlayerDataHolder(this.plugin, this.credential);
        CompletableFuture.runAsync(() -> {
            long loadStart = System.currentTimeMillis();
            for (PlayerData oldData : this.holder.getAllPlayerDatas()) {
                this.newHolder.getData().putIfAbsent(oldData.getUuid(), oldData);
            }
            this.newHolder.save(true);
            long loadEnd = System.currentTimeMillis();
            long loadElapsedTime = loadEnd - loadStart;
            this.holder.getDatabase().shutdown();
            boolean deleted = false;
            try {
                this.newHolder.getDatabase().executeQuery("DROP TABLE " + this.holder.getDatabase().getDbTable() + " ;", true);
                deleted = true;
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            if (deleted) {
                DebugLogger.logDebugMessage("Old Stats Table Deleted.");
            }
            DebugLogger.logDebugMessage("Data Converting time: " + loadElapsedTime + "ms");
            DebugLogger.logDebugMessage("Converted " + this.holder.getAllPlayerDatas().size() + " users.");
        }).whenComplete((t, s) -> {
            this.completed = true;
        });
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

