/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.leaderboards;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.DebugLogger;
import me.extremesnow.statssb.utils.ObjectSorter;

public class Leaderboard {
    private final StatsSB plugin;
    private Map<PlayerData, Object> dataMap = new LinkedHashMap<PlayerData, Object>();
    private final StatType statType;
    private boolean async = true;
    private boolean statsChanged = false;

    public Leaderboard(StatsSB plugin, StatType statType) {
        this.plugin = plugin;
        this.statType = statType;
        this.build();
    }

    public void build() {
        this.init();
    }

    public void init() {
        if (this.async) {
            CompletableFuture.runAsync(() -> {
                for (PlayerData playerData : this.plugin.getPlayerDataHolder().getAllPlayerDatas()) {
                    if (this.dataMap.containsKey(playerData)) {
                        this.dataMap.replace(playerData, playerData.getStat(this.statType).getValue());
                        continue;
                    }
                    Object statValue = playerData.getStat(this.statType).getValue();
                    if (statValue == null) {
                        statValue = this.statType.getType() == Integer.TYPE ? (Number)0 : (Number)0.0;
                    }
                    this.dataMap.putIfAbsent(playerData, statValue);
                }
                this.dataMap = this.sort(new LinkedHashMap<PlayerData, Object>(this.dataMap));
                DebugLogger.logDebugMessage(this.statType.name() + " DataMap Sorted");
            }).whenComplete((t, s) -> this.updateScores());
        }
    }

    public void updateScores() {
        CompletableFuture.runAsync(() -> {
            int rank = 1;
            for (PlayerData entry : this.dataMap.keySet()) {
                entry.getStat(this.statType).setRank(rank);
                ++rank;
            }
            this.plugin.getPlayerDataHolder().save(true, () -> DebugLogger.logDebugMessage("Finished Sorting: " + this.statType.name()));
        });
    }

    public boolean buildIfChanged() {
        if (this.statsChanged) {
            this.build();
            this.statsChanged = false;
            return true;
        }
        return false;
    }

    public Map<PlayerData, Object> getTop(int amount) {
        LinkedHashMap<PlayerData, Object> topAmount = new LinkedHashMap<PlayerData, Object>();
        int i = 0;
        for (Map.Entry<PlayerData, Object> entry : this.dataMap.entrySet()) {
            if (i == amount) break;
            topAmount.put(entry.getKey(), entry.getValue());
            ++i;
        }
        return topAmount;
    }

    public void addPlayer(PlayerData playerData, Object baseAmount) {
        this.dataMap.putIfAbsent(playerData, baseAmount);
    }

    private Map<PlayerData, Object> sort(Map<PlayerData, Object> items) {
        boolean isDouble;
        boolean bl = isDouble = this.statType.getType() == Double.TYPE;
        if (isDouble) {
            return ObjectSorter.sortDouble(items);
        }
        return ObjectSorter.sortInt(items);
    }

    public StatType getStatType() {
        return this.statType;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isStatsChanged() {
        return this.statsChanged;
    }

    public void setStatsChanged(boolean statsChanged) {
        this.statsChanged = statsChanged;
    }
}

