/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.hologram;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.DebugLogger;
import me.extremesnow.statssb.utils.MathUtil;
import me.extremesnow.statssb.utils.Utilities;
import me.extremesnow.statssb.utils.files.ConfigFile;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class StatHologram {
    private final StatsSB plugin;
    public String id;
    private StatType statType;
    private Location location;
    private long creationTimestamp;
    private Hologram hologram;
    private List<Object> lines = new LinkedList<Object>();
    private Map<PlayerData, Object> dataMap;

    public StatHologram(StatsSB plugin, String id, StatType statType, Location location) {
        this.plugin = plugin;
        this.id = id;
        this.statType = statType;
        this.location = location;
        this.updateMap();
        this.create();
    }

    public void updateMap() {
        int showAmount = this.plugin.getFileUtil().getConfigFile().getHologramNumberOfPlayers();
        this.dataMap = new LinkedHashMap<PlayerData, Object>(this.plugin.getLeaderboards().get((Object)this.statType).getTop(showAmount + 2));
    }

    private void create() {
        ConfigFile config = this.plugin.getFileUtil().getConfigFile();
        String title = this.getTitle(config);
        if (this.dataMap.size() <= 0) {
            DebugLogger.logDebugMessage("Error.HOLOGRAM_MAP_EMPTY");
            return;
        }
        this.hologram = HologramsAPI.createHologram((Plugin)this.plugin, (Location)this.location);
        this.creationTimestamp = this.hologram.getCreationTimestamp();
        this.hologram.appendTextLine(title);
        this.hologram.appendTextLine("\u00a7r");
        int showAmount = config.getHologramNumberOfPlayers();
        int count = 0;
        try {
            for (Map.Entry<PlayerData, Object> entry : this.dataMap.entrySet()) {
                if (count != showAmount) {
                    String entryName = entry.getKey().getName();
                    if (entryName == null) {
                        entryName = "nullPlayer";
                    }
                    String format = config.getHologramPlayerFormat();
                    Object oEntry = entry.getValue();
                    if (this.statType.getType() == Double.TYPE) {
                        oEntry = MathUtil.roundTwoDecimals((Double)oEntry);
                    }
                    String value = MathUtil.addCommas(oEntry);
                    TextLine text = this.hologram.appendTextLine("" + format.replace("%rank%", count + 1 + "").replace("%player%", entryName).replace("%amount%", value + "" + Utilities.plural(value, StringUtils.capitalize((String)this.statType.name().toLowerCase()))));
                    this.lines.add(text);
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DebugLogger.logDebugMessage("Error.HOLOGRAM_GENERAL" + e.getMessage());
        }
    }

    public boolean refresh() {
        try {
            this.updateMap();
            ConfigFile configFile = this.plugin.getFileUtil().getConfigFile();
            int showAmount = configFile.getHologramNumberOfPlayers();
            int count = 0;
            if (this.dataMap.size() <= 0) {
                return false;
            }
            if (this.dataMap.size() < showAmount) {
                showAmount = this.dataMap.size();
            }
            for (Map.Entry<PlayerData, Object> entry : this.dataMap.entrySet()) {
                if (count != showAmount) {
                    String format = configFile.getHologramPlayerFormat();
                    String entryName = entry.getKey().getName();
                    if (entryName == null) {
                        entryName = "nullPlayer";
                    }
                    Object oEntry = entry.getValue();
                    if (this.statType.getType() == Double.TYPE) {
                        oEntry = MathUtil.roundTwoDecimals((Double)oEntry);
                    }
                    String value = MathUtil.addCommas(oEntry);
                    String lineText = format.replace("%rank%", count + 1 + "").replace("%player%", entryName).replace("%amount%", value + Utilities.plural(value, StringUtils.capitalize((String)this.statType.name().toLowerCase())));
                    if (this.lines.size() <= count && count < showAmount) {
                        DebugLogger.logDebugMessage("objects size: " + this.lines.size());
                        TextLine text = this.hologram.appendTextLine(lineText);
                        this.lines.add(text);
                        ++count;
                        continue;
                    }
                    ((TextLine)this.lines.get(count)).setText(lineText);
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DebugLogger.logDebugMessage("Error.HOLOGRAM_REFRESH, " + e.getMessage());
            return false;
        }
        return true;
    }

    public void delete() {
        if (this.hologram != null) {
            this.hologram.delete();
        }
        this.dataMap = null;
        this.lines = null;
        this.creationTimestamp = 0L;
        this.hologram = null;
        this.location = null;
        this.id = null;
        this.statType = null;
    }

    private String getTitle(ConfigFile configFile) {
        if (this.statType == StatType.DEATH) {
            return configFile.getHologramDeathsTitle();
        }
        return configFile.getHologramKillsTitle();
    }

    public String getId() {
        return this.id;
    }

    public StatType getStatType() {
        return this.statType;
    }

    public Location getLocation() {
        return this.location;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

