/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.hologram;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.hologram.StatHologram;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.DebugLogger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class HologramManager {
    private final StatsSB plugin;
    private boolean isEnabled = false;
    private BukkitTask hologramUpdateTask;
    private HashMap<String, StatHologram> hologramMap;

    public HologramManager(StatsSB plugin) {
        this.plugin = plugin;
        this.hologramMap = new HashMap();
    }

    public void load() {
        if (this.plugin.isUseHolographicDisplays()) {
            this.startup();
            this.isEnabled = true;
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void startup() {
        File holofile = new File(this.plugin.getDataFolder(), "holograms.yml");
        YamlConfiguration holoList = YamlConfiguration.loadConfiguration((File)holofile);
        if (holoList.getConfigurationSection("holograms") == null) {
            DebugLogger.logDebugMessage("Error.HOLOGRAM_FILE_EMPTY");
            return;
        }
        Set names = holoList.getConfigurationSection("holograms").getKeys(false);
        for (String id : names) {
            if (Bukkit.getWorld((String)holoList.getString("holograms." + id + ".location.world")) == null) {
                DebugLogger.logDebugMessage("Error.HOLOGRAM_WORLD_NOT_EXIST, Problem Hologram Name: " + id + " World that doesn't exist: " + holoList.getString("holograms." + id + ".location.world"));
                return;
            }
            double x = holoList.getDouble("holograms." + id + ".location.x");
            double y = holoList.getDouble("holograms." + id + ".location.y");
            double z = holoList.getDouble("holograms." + id + ".location.z");
            String type = holoList.getString("holograms." + id + ".type");
            DebugLogger.logDebugMessage("\u00a79Hologram: \u00a7c" + id + " \u00a79Type: \u00a7c" + type + " \u00a79creating.");
            Location loc = new Location(Bukkit.getWorld((String)holoList.getString("holograms." + id + ".location.world")), x, y, z);
            StatType statType = StatType.matchCommonNameStat(type);
            this.create(id, statType, loc);
        }
        this.updateBoards();
    }

    public void create(String id, StatType statType, Location location) {
        StatHologram hologram = new StatHologram(this.plugin, id, statType, location);
        this.hologramMap.put(id, hologram);
    }

    public void updateBoards() {
        this.hologramUpdateTask = new BukkitRunnable(){

            public void run() {
                for (StatHologram hologram : HologramManager.this.hologramMap.values()) {
                    if (hologram.getHologram() == null || hologram.refresh()) continue;
                    HologramManager.this.rebootHolograms();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 100L, 100L);
    }

    public void rebootHolograms() {
        DebugLogger.logDebugMessage("Error.HOLOGRAM_REBOOT, true");
        if (this.hologramUpdateTask != null) {
            this.hologramUpdateTask.cancel();
        }
        new BukkitRunnable(){

            public void run() {
                for (StatHologram hologram : HologramManager.this.hologramMap.values()) {
                    hologram.delete();
                }
                HologramManager.this.startup();
            }
        }.runTaskLater((Plugin)this.plugin, 140L);
    }

    public HashMap<String, StatHologram> getHolograms() {
        return this.hologramMap;
    }
}

