/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.extremesnow.datalib.data.SQLCredential;
import me.extremesnow.datalib.data.storage.StorageHolder;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.utils.DebugLogger;

public class PlayerDataHolder
extends StorageHolder<PlayerData> {
    private final StatsSB plugin;
    private Map<UUID, PlayerData> data = new ConcurrentHashMap<UUID, PlayerData>();

    public PlayerDataHolder(StatsSB plugin, SQLCredential credential) {
        super(credential.build());
        this.plugin = plugin;
        this.addVariant(credential.getTable(), PlayerData.class);
        this.load(false);
    }

    @Override
    protected void onAdd(PlayerData playerData) {
        DebugLogger.logDebugMessage("Adding new Player to dataset: " + playerData.getUuid());
        this.data.put(playerData.getUuid(), playerData);
    }

    @Override
    protected void onRemove(PlayerData playerData) {
        this.data.remove(playerData.getUuid());
    }

    @Override
    public void batchSave(List<PlayerData> batch, boolean async, Runnable callback) {
    }

    @Override
    public Iterator<PlayerData> iterator() {
        return this.data.values().iterator();
    }

    public PlayerData getOrNull(UUID uuid) {
        return this.data.get(uuid);
    }

    public PlayerData getOrInsert(UUID uuid) {
        PlayerData playerData = this.data.get(uuid);
        if (playerData == null) {
            playerData = new PlayerData(this.plugin, uuid);
            this.add(playerData);
        }
        return playerData;
    }

    public Set<String> getAllNames() {
        HashSet<String> userNames = new HashSet<String>();
        for (PlayerData entry : this.data.values()) {
            userNames.add(entry.getName());
        }
        return userNames;
    }

    public Set<PlayerData> getAllPlayerDatas() {
        return new HashSet<PlayerData>(this.data.values());
    }

    public Set<UUID> getAllUUIDs() {
        return new HashSet<UUID>(this.data.keySet());
    }

    public Set<String> getAllNamesLowercase() {
        HashSet<String> userNames = new HashSet<String>();
        for (PlayerData entry : this.data.values()) {
            userNames.add(entry.getName().toLowerCase());
        }
        return userNames;
    }

    public Map<UUID, PlayerData> getData() {
        return this.data;
    }
}

