/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.extremesnow.datalib.data.storage.DataObject;
import me.extremesnow.datalib.data.storage.SerializedData;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.board.Board;
import me.extremesnow.statssb.stat.Stat;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.MathUtil;
import me.extremesnow.statssb.utils.Utilities;
import org.bukkit.Bukkit;

public class PlayerData
extends DataObject
implements Cloneable {
    private StatsSB plugin;
    private UUID uuid;
    private String name;
    private Map<StatType, Stat> statMap;
    private PlayerData lastHitter;
    private Board board;

    public PlayerData() {
        this.plugin = StatsSB.getInstance();
        this.populateStatMap();
        this.loadBoard();
    }

    public PlayerData(StatsSB plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.populateStatMap();
        this.loadBoard();
    }

    public void loadBoard() {
        this.board = new Board(this.plugin, this);
    }

    public void startBoard() {
        if (Utilities.checkEnabledLocation(this.plugin, Bukkit.getPlayer((UUID)this.uuid))) {
            this.board.start();
        }
    }

    private void populateStatMap() {
        if (this.statMap == null) {
            this.statMap = new HashMap<StatType, Stat>();
        }
        for (StatType type : StatType.values()) {
            if (this.statMap.containsKey((Object)type) && this.statMap.get((Object)type) != null) continue;
            Stat stat = new Stat(type, 0);
            this.statMap.put(type, stat);
        }
    }

    public Stat getStat(StatType type) {
        return this.statMap.get((Object)type);
    }

    public void addStat(StatType statType, Object amount) {
        Stat stat = this.statMap.get((Object)statType);
        stat.addNumberValue(amount);
    }

    public void removeStat(StatType statType, Object amount) {
        Stat stat = this.statMap.get((Object)statType);
        stat.removeNumberValue(amount);
    }

    public void setStat(StatType statType, Object amount) {
        Stat stat = this.statMap.get((Object)statType);
        stat.setValue(amount);
    }

    public List<String> replacePlaceholders(List<String> stringList) {
        ArrayList<String> replaced = new ArrayList<String>();
        for (String s : stringList) {
            replaced.add(this.replacePlaceholders(s));
        }
        return replaced;
    }

    public String replacePlaceholders(String string) {
        int kills = (Integer)this.getStat(StatType.KILL).getValue();
        int killsRank = this.getStat(StatType.KILL).getRank();
        int deaths = (Integer)this.getStat(StatType.DEATH).getValue();
        int deathsRank = this.getStat(StatType.DEATH).getRank();
        int streak = (Integer)this.getStat(StatType.KILL_STREAK).getValue();
        double kd = 0.0;
        if ((double)deaths == 0.0) {
            kd = kills;
        } else if ((double)deaths >= 1.0) {
            kd = (double)kills / (double)deaths;
        }
        String lastHit = "";
        if (this.lastHitter != null) {
            lastHit = this.lastHitter.getName();
        }
        string = string.replace("%last_hitter%", lastHit).replace("%kills%", MathUtil.addCommas(kills) + "").replace("%rank%", "#" + MathUtil.addCommas(killsRank)).replace("%kills_rank%", "#" + MathUtil.addCommas(killsRank)).replace("%kills-rank%", "#" + MathUtil.addCommas(killsRank)).replace("%deaths_rank%", "#" + MathUtil.addCommas(deathsRank)).replace("%deaths-rank%", "#" + MathUtil.addCommas(deathsRank)).replace("%deaths%", MathUtil.addCommas(deaths) + "").replace("%kd%", MathUtil.roundTwoDecimals(kd) + "").replace("%streak%", MathUtil.addCommas(streak) + "").replace("%player_name%", this.name).replace("%player-name%", this.name).replace("%player%", this.name).replace("%user%", this.name).replace("%uuid%", this.uuid + "").replace("&", "\u00a7");
        return Utilities.replacePlaceholders(this.plugin, this, string, false);
    }

    @Override
    public String[] getStructure() {
        return new String[]{"uuid", "name", "kills", "kills_rank", "deaths", "deaths_rank", "streak"};
    }

    @Override
    public String getKey() {
        return this.uuid.toString();
    }

    @Override
    public void serialize(SerializedData serializedData) {
        serializedData.write("uuid", this.uuid);
        serializedData.write("name", this.name);
        int kills = (Integer)this.getStat(StatType.KILL).getValue();
        int killsRank = this.getStat(StatType.KILL).getRank();
        int streak = (Integer)this.getStat(StatType.KILL_STREAK).getValue();
        int deaths = (Integer)this.getStat(StatType.DEATH).getValue();
        int deathsRank = this.getStat(StatType.DEATH).getRank();
        serializedData.write("kills", kills);
        serializedData.write("kills_rank", killsRank);
        serializedData.write("deaths", deaths);
        serializedData.write("deaths_rank", deathsRank);
        serializedData.write("streak", streak);
    }

    @Override
    public void deserialize(SerializedData data) {
        int killsValue;
        try {
            killsValue = data.applyAs("kills", Integer.TYPE);
        }
        catch (Exception e) {
            this.deserializeOld(data);
            return;
        }
        this.uuid = data.applyAs("uuid", UUID.class);
        this.name = data.applyAs("name", String.class);
        Stat kill = this.getStat(StatType.KILL);
        Stat death = this.getStat(StatType.DEATH);
        Stat kill_streak = this.getStat(StatType.KILL_STREAK);
        int killsRank = data.applyAs("kills_rank", Integer.TYPE);
        int deathsValue = data.applyAs("deaths", Integer.TYPE);
        int deathsRank = data.applyAs("deaths_rank", Integer.TYPE);
        int kill_s_value = data.applyAs("streak", Integer.TYPE);
        kill.setValue(killsValue);
        kill.setRank(killsRank);
        death.setValue(deathsValue);
        death.setRank(deathsRank);
        kill_streak.setValue(kill_s_value);
    }

    @Override
    public void deserializeOld(SerializedData data) {
        try {
            data.applyAs("kills_rank", Integer.TYPE);
        }
        catch (Exception e) {
            this.deserializeLite(data);
            return;
        }
        this.uuid = UUID.fromString(data.applyAs("uuid", String.class).replace("\"", ""));
        this.name = data.applyAs("name", String.class).replace("\"", "");
        Stat kill = this.getStat(StatType.KILL);
        Stat death = this.getStat(StatType.DEATH);
        Stat kill_streak = this.getStat(StatType.KILL_STREAK);
        int killsValue = data.applyAsFromOld("kills", Integer.TYPE);
        int killsRank = data.applyAsFromOld("kills_rank", Integer.TYPE);
        int deathsValue = data.applyAsFromOld("deaths", Integer.TYPE);
        int deathsRank = data.applyAsFromOld("deaths_rank", Integer.TYPE);
        int kill_s_value = data.applyAsFromOld("streak", Integer.TYPE);
        kill.setValue(killsValue);
        kill.setRank(killsRank);
        death.setValue(deathsValue);
        death.setRank(deathsRank);
        kill_streak.setValue(kill_s_value);
    }

    @Override
    public void deserializeLite(SerializedData data) {
        this.uuid = data.applyAsFromOld("uuid", UUID.class);
        this.name = data.applyAsFromOld("name", String.class);
        Stat kill = this.getStat(StatType.KILL);
        Stat death = this.getStat(StatType.DEATH);
        Stat kill_streak = this.getStat(StatType.KILL_STREAK);
        int killsValue = data.applyAsFromOld("kills", Integer.TYPE);
        int killsRank = data.applyAsFromOld("killsRank", Integer.TYPE);
        int deathsValue = data.applyAsFromOld("deaths", Integer.TYPE);
        int deathsRank = data.applyAsFromOld("deathsRank", Integer.TYPE);
        int kill_s_value = data.applyAsFromOld("streak", Integer.TYPE);
        kill.setValue(killsValue);
        kill.setRank(killsRank);
        death.setValue(deathsValue);
        death.setRank(deathsRank);
        kill_streak.setValue(kill_s_value);
    }

    @Override
    public void save() {
        StatsSB.getInstance().getPlayerDataHolder().save(this, true, null);
    }

    public PlayerData clone() {
        try {
            return (PlayerData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public StatsSB getPlugin() {
        return this.plugin;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Map<StatType, Stat> getStatMap() {
        return this.statMap;
    }

    public PlayerData getLastHitter() {
        return this.lastHitter;
    }

    public void setPlugin(StatsSB plugin) {
        this.plugin = plugin;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatMap(Map<StatType, Stat> statMap) {
        this.statMap = statMap;
    }

    public void setLastHitter(PlayerData lastHitter) {
        this.lastHitter = lastHitter;
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public Board getBoard() {
        return this.board;
    }
}

