/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.commands.tsb;

import java.util.ArrayList;
import java.util.List;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.commands.BaseCommand;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.utils.Permission;
import me.extremesnow.statssb.utils.Utilities;
import me.extremesnow.statssb.utils.files.ConfigFile;
import me.extremesnow.statssb.utils.files.MessageHandler;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TSBBaseCommand
extends BaseCommand {
    private final StatsSB plugin;

    public TSBBaseCommand(StatsSB plugin) {
        this.plugin = plugin;
    }

    @Override
    public Permission getPermission() {
        return Permission.TOGGLE_SCOREBOARD;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[&bStatsSB&3] &cCannot be run from console."));
            return true;
        }
        Player paramPlayer = (Player)sender;
        ConfigFile configFile = this.plugin.getFileUtil().getConfigFile();
        if (!configFile.isScoreboardEnabled()) {
            paramPlayer.sendMessage(MessageHandler.getMessage(MessageHandler.Message.SERVER_DISABLED_BOARD));
            return true;
        }
        PlayerData playerData = this.plugin.getPlayerData(paramPlayer.getUniqueId());
        if (configFile.isDisableCertainWorlds() && !Utilities.containsString(paramPlayer.getWorld().getName(), configFile.getEnabledWorlds())) {
            paramPlayer.sendMessage(MessageHandler.getMessage(MessageHandler.Message.WORLD_DISABLED_BOARD));
            return true;
        }
        if (!playerData.getBoard().isToggledOn()) {
            playerData.getBoard().setToggledOn(true);
            playerData.getBoard().start();
            paramPlayer.sendMessage(configFile.getScoreboardToggleOn());
            return true;
        }
        playerData.getBoard().setToggledOn(false);
        playerData.getBoard().remove();
        paramPlayer.sendMessage(configFile.getScoreboardToggleOff());
        return true;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String[] args) {
        return this.onCommand(sender, cmd);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String[] args) {
        return new ArrayList<String>();
    }
}

