/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.commands.sb;

import java.util.ArrayList;
import java.util.List;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.commands.Subcommand;
import me.extremesnow.statssb.utils.DebugLogger;
import me.extremesnow.statssb.utils.Permission;
import me.extremesnow.statssb.utils.files.MessageHandler;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SBReloadSubcommand
implements Subcommand {
    private final StatsSB plugin;

    public SBReloadSubcommand(StatsSB plugin) {
        this.plugin = plugin;
    }

    public String getHelp() {
        return "Reloads the plugin configuration";
    }

    public String getUsage() {
        return "/statssb reload";
    }

    @Override
    public Permission getPermission() {
        return Permission.RELOAD;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String[] args) {
        DebugLogger.logDebugMessage("&aReloading.");
        this.plugin.reloadFileUtils();
        this.plugin.onReload();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.plugin.getPlayerData(p).getBoard().restart();
        }
        if (this.plugin.getHologramManager().isEnabled()) {
            this.plugin.getHologramManager().rebootHolograms();
        }
        sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.RELOAD_SUCCESSFUL));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String[] args) {
        return new ArrayList<String>();
    }
}

