/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.commands.sb;

import java.util.ArrayList;
import java.util.List;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.commands.Subcommand;
import me.extremesnow.statssb.hologram.StatHologram;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.Permission;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SBDisplaysSubcommand
implements Subcommand {
    private final StatsSB plugin;

    public SBDisplaysSubcommand(StatsSB plugin) {
        this.plugin = plugin;
    }

    public String getHelp() {
        return "Shows current hologram displays from the plugin";
    }

    public String getUsage() {
        return "/statssb displays";
    }

    @Override
    public Permission getPermission() {
        return Permission.ADMIN;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[&bStatsSB&3] &cCannot be run from console."));
            return true;
        }
        if (args.length > 2) {
            sender.sendMessage(ChatColor.DARK_AQUA + "[" + ChatColor.AQUA + "StatsSB" + ChatColor.DARK_AQUA + "] " + ChatColor.RED + "Correct Usage: " + ChatColor.GRAY + "/statssb deletedisplay <name>");
            return true;
        }
        if (!this.plugin.isUseHolographicDisplays()) {
            sender.sendMessage(ChatColor.DARK_AQUA + "[" + ChatColor.AQUA + "StatsSB" + ChatColor.DARK_AQUA + "] " + ChatColor.RED + "Holographic Displays cannot be found on this server.");
            return true;
        }
        sender.sendMessage(ChatColor.DARK_GRAY + "----------" + ChatColor.DARK_AQUA + " Holograms" + ChatColor.DARK_GRAY + " ----------");
        for (StatHologram sbHolo : this.plugin.getHologramManager().getHolograms().values()) {
            String color = sbHolo.getStatType() == StatType.KILL ? "\u00a7a" : (sbHolo.getStatType() == StatType.DEATH ? "\u00a7c" : "\u00a73");
            sender.sendMessage(ChatColor.DARK_GRAY + "-  \u00a77Name: \u00a7b" + sbHolo.getId() + " \u00a77Type: " + color + sbHolo.getStatType().getCommonName());
        }
        sender.sendMessage(ChatColor.DARK_GRAY + "------------------------------");
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String[] args) {
        return new ArrayList<String>();
    }
}

