/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.commands.sb;

import java.util.ArrayList;
import java.util.List;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.commands.Subcommand;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.MathUtil;
import me.extremesnow.statssb.utils.Permission;
import me.extremesnow.statssb.utils.files.MessageHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SBAddSubcommand
implements Subcommand {
    private final StatsSB plugin;

    public SBAddSubcommand(StatsSB plugin) {
        this.plugin = plugin;
    }

    public String getHelp() {
        return "Add amount to a players stats.";
    }

    public String getUsage() {
        return MessageHandler.getMessage(MessageHandler.Message.ADD_USAGE);
    }

    @Override
    public Permission getPermission() {
        return Permission.SET;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String[] args) {
        if (args.length < 4) {
            sender.sendMessage(this.getUsage());
            return true;
        }
        PlayerData target = null;
        for (PlayerData playerData : this.plugin.getPlayerDataHolder().getAllPlayerDatas()) {
            if (playerData.getName() == null || !playerData.getName().equalsIgnoreCase(args[1])) continue;
            target = playerData;
        }
        if (target == null) {
            sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.ADD_NOT_EXIST).replace("%name%", args[1]));
            return true;
        }
        if (!MathUtil.isInt(args[3])) {
            sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.ADD_MUST_BE_NUMBER));
            return true;
        }
        int amount = Integer.parseInt(args[3]);
        String type = args[2].toLowerCase();
        StatType statType = StatType.matchStatType(type);
        if (statType == null) {
            statType = StatType.matchCommonNameStat(type);
        }
        if (statType == null) {
            sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.PREFIX) + ChatColor.RED + type + ChatColor.GRAY + " is not a valid StatType.");
            StringBuilder types = new StringBuilder();
            for (StatType statType1 : StatType.values()) {
                types.append(statType1.getCommonName()).append(", ");
            }
            sender.sendMessage(ChatColor.GRAY + "Valid Types are:");
            sender.sendMessage(ChatColor.AQUA + types.toString());
            return true;
        }
        PlayerData finalTarget = target;
        finalTarget.addStat(statType, amount);
        finalTarget.save();
        int newAmount = (Integer)finalTarget.getStat(statType).getValue();
        sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.ADD_DONE).replace("%amount%", MathUtil.addCommas(amount)).replace("%newamount%", MathUtil.addCommas(newAmount)).replace("%name%", args[1]).replace("%type%", type));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String[] args) {
        if (args.length == 2) {
            ArrayList<String> playerNames = new ArrayList<String>();
            Player[] players = new Player[Bukkit.getOnlinePlayers().size()];
            Bukkit.getOnlinePlayers().toArray(players);
            for (Player player : players) {
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        if (args.length == 3) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("kills");
            list.add("deaths");
            return list;
        }
        if (args.length == 4) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("<amount>");
            return list;
        }
        return null;
    }
}

