/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb.commands.lb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.commands.BaseCommand;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.MathUtil;
import me.extremesnow.statssb.utils.Permission;
import me.extremesnow.statssb.utils.Utilities;
import me.extremesnow.statssb.utils.files.ConfigFile;
import me.extremesnow.statssb.utils.files.MessageHandler;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class LeaderboardBaseCommand
extends BaseCommand {
    private final StatsSB plugin;

    public LeaderboardBaseCommand(StatsSB plugin) {
        this.plugin = plugin;
    }

    @Override
    public Permission getPermission() {
        return Permission.LEADERBOARD;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd) {
        return this.onCommand(sender, cmd, new String[0]);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String[] args) {
        ConfigFile configFile = this.plugin.getFileUtil().getConfigFile();
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.PLAYER_REQUIRED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendLeaderboard(player, StatType.KILL);
            return true;
        }
        String type = args[0].toLowerCase();
        StatType statType = StatType.matchStatType(type);
        if (statType == null) {
            statType = StatType.matchCommonNameStat(type);
        }
        if (statType == null) {
            sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.PREFIX) + ChatColor.RED + type + ChatColor.GRAY + " is not a valid StatType.");
            StringBuilder types = new StringBuilder();
            for (StatType statType1 : StatType.values()) {
                types.append(statType1.name()).append(", ");
            }
            sender.sendMessage(ChatColor.GRAY + "Valid Types are:");
            sender.sendMessage(ChatColor.AQUA + types.toString());
            return true;
        }
        this.sendLeaderboard(player, statType);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String[] args) {
        if (args.length == 1) {
            ArrayList<String> names = new ArrayList<String>();
            for (StatType type : StatType.values()) {
                names.add(StringUtils.capitalize((String)type.name().toLowerCase()));
            }
            ArrayList<String> newList = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], names, newList);
            Collections.sort(newList);
            return newList;
        }
        return new ArrayList<String>();
    }

    public void sendLeaderboard(Player player, StatType statType) {
        ConfigFile configFile = this.plugin.getFileUtil().getConfigFile();
        int showAmount = configFile.getLeaderboardNumberOfPlayers();
        LinkedHashMap<PlayerData, Object> dataMap = new LinkedHashMap<PlayerData, Object>(this.plugin.getLeaderboards().get((Object)statType).getTop(showAmount + 2));
        int size = configFile.getLeaderboardMessage().size();
        List stringList = configFile.getLeaderboardMessage();
        String title = Utilities.getLBTitle(this.plugin, statType);
        if (dataMap.size() < showAmount) {
            showAmount = dataMap.size();
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            stringList = PlaceholderAPI.setPlaceholders((Player)player, stringList);
        }
        int count = 1;
        block0: for (int i = 0; i < size; ++i) {
            if (((String)stringList.get(i)).contains("%players%")) {
                for (Map.Entry<PlayerData, Object> entry : dataMap.entrySet()) {
                    String format = configFile.getLeaderboardPlayerFormat();
                    Object stat = entry.getKey().getStat(statType).getValue();
                    if (stat instanceof Double) {
                        stat = MathUtil.roundTwoDecimals((Double)stat);
                    }
                    player.sendMessage("" + format.replace("%rank%", entry.getKey().getStat(statType).getRank() + "").replace("%player%", entry.getKey().getName()).replace("%name%", entry.getKey().getName()).replace("%amount%", MathUtil.addCommas(stat) + ""));
                    if (count >= showAmount) continue block0;
                    ++count;
                }
                continue;
            }
            player.sendMessage(((String)stringList.get(i)).replace("&", "\u00a7").replace("%title%", title));
        }
    }
}

