/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb;

import java.util.UUID;
import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.leaderboards.Leaderboard;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.DebugLogger;
import org.bukkit.entity.Player;

public class StatsSBAPI {
    private static StatsSBAPI instance;
    private final StatsSB plugin;

    public static StatsSBAPI getAPI() {
        return instance;
    }

    protected StatsSBAPI(StatsSB plugin) {
        this.plugin = plugin;
        if (instance == null) {
            instance = this;
        }
    }

    public DangerousAPI getDangerousAPI() {
        return new DangerousAPI();
    }

    public Object getStatValue(Player player, StatType statType) {
        PlayerData playerData = this.plugin.getPlayerData(player.getUniqueId());
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return 0;
        }
        return playerData.getStat(statType).getValue();
    }

    public Object getStatValue(UUID uuid, StatType statType) {
        PlayerData playerData = this.plugin.getPlayerData(uuid);
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return 0;
        }
        return playerData.getStat(statType).getValue();
    }

    public Object getStatRank(Player player, StatType statType) {
        PlayerData playerData = this.plugin.getPlayerData(player.getUniqueId());
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return 0;
        }
        return playerData.getStat(statType).getRank();
    }

    public Object getStatRank(UUID uuid, StatType statType) {
        PlayerData playerData = this.plugin.getPlayerData(uuid);
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return 0;
        }
        return playerData.getStat(statType).getRank();
    }

    public boolean setStatValue(Player player, StatType statType, Object value) {
        PlayerData playerData = this.plugin.getPlayerData(player.getUniqueId());
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        try {
            playerData.setStat(statType, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setStatValue(UUID uuid, StatType statType, Object value) {
        PlayerData playerData = this.plugin.getPlayerData(uuid);
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        try {
            playerData.setStat(statType, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean savePlayer(Player player) {
        PlayerData playerData = this.plugin.getPlayerData(player.getUniqueId());
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        playerData.save();
        return true;
    }

    public boolean savePlayer(UUID uuid) {
        PlayerData playerData = this.plugin.getPlayerData(uuid);
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        playerData.save();
        return true;
    }

    public boolean simulateDeath(Player player) {
        PlayerData playerData = this.plugin.getPlayerData(player.getUniqueId());
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        this.plugin.getPlayerStatManager().addStatAsync(playerData, StatType.DEATH, 1);
        return true;
    }

    public boolean simulateKill(Player victim, Player attacker) {
        PlayerData sbVictim = this.plugin.getPlayerData(victim.getUniqueId());
        PlayerData sbAttacker = this.plugin.getPlayerData(attacker.getUniqueId());
        if (sbAttacker == null || sbVictim == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        this.plugin.getPlayerStatManager().addStatAsync(sbAttacker, StatType.KILL, 1);
        this.plugin.getPlayerStatManager().addStatAsync(sbVictim, StatType.DEATH, 1);
        return true;
    }

    public boolean simulateDeath(UUID uuid) {
        PlayerData playerData = this.plugin.getPlayerData(uuid);
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        this.plugin.getPlayerStatManager().addStatAsync(playerData, StatType.DEATH, 1);
        return true;
    }

    public boolean simulateKill(UUID victim, UUID attacker) {
        PlayerData sbVictim = this.plugin.getPlayerData(victim);
        PlayerData sbAttacker = this.plugin.getPlayerData(attacker);
        if (sbAttacker == null || sbVictim == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return false;
        }
        this.plugin.getPlayerStatManager().addStatAsync(sbAttacker, StatType.KILL, 1);
        this.plugin.getPlayerStatManager().addStatAsync(sbVictim, StatType.DEATH, 1);
        return true;
    }

    public void refreshLeaderboard(StatType statType) {
        Leaderboard leaderboard = this.plugin.getLeaderboards().get((Object)statType);
        leaderboard.setStatsChanged(true);
    }

    public void refreshLeaderboards() {
        for (Leaderboard leaderboard : this.plugin.getLeaderboards().values()) {
            leaderboard.setStatsChanged(true);
        }
    }

    public PlayerData getPlayerData(Player player) {
        PlayerData playerData = this.plugin.getPlayerData(player.getUniqueId());
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return null;
        }
        return playerData.clone();
    }

    public PlayerData getPlayerData(UUID uuid) {
        PlayerData playerData = this.plugin.getPlayerData(uuid);
        if (playerData == null) {
            DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
            return null;
        }
        return playerData.clone();
    }

    static /* synthetic */ StatsSB access$100(StatsSBAPI x0) {
        return x0.plugin;
    }

    public class DangerousAPI {
        private final StatsSB plugin = StatsSBAPI.access$100(StatsSBAPI.getAPI());

        private DangerousAPI() {
        }

        public PlayerData getPlayerData(Player player) {
            PlayerData playerData = this.plugin.getPlayerData(player.getUniqueId());
            if (playerData == null) {
                DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
                return null;
            }
            return playerData;
        }

        public PlayerData getPlayerData(UUID uuid) {
            PlayerData playerData = this.plugin.getPlayerData(uuid);
            if (playerData == null) {
                DebugLogger.logConsoleMessage("&cAPI Method called, Player passed is null.");
                return null;
            }
            return playerData;
        }
    }
}

