/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.statssb;

import me.extremesnow.statssb.StatsSB;
import me.extremesnow.statssb.data.PlayerData;
import me.extremesnow.statssb.stat.StatType;
import me.extremesnow.statssb.utils.DebugLogger;
import me.extremesnow.statssb.utils.PlayerStatManager;
import me.extremesnow.statssb.utils.Utilities;
import me.extremesnow.statssb.utils.files.ConfigFile;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class Events
implements Listener {
    private StatsSB plugin;

    public Events(StatsSB plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        PlayerData playerData = this.plugin.getPlayerDataHolder().getOrInsert(player.getUniqueId());
        playerData.setName(player.getName());
        playerData.save();
        playerData.startBoard();
        Utilities.addToPlayerMaps(this.plugin, playerData);
        if (player.hasPermission("statssb.admin") && this.plugin.isNeedsUpdate() && this.plugin.getFileUtil().getConfigFile().isUpdateChecking()) {
            player.sendMessage(ChatColor.AQUA + "Stats Scoreboard Update available.");
            player.sendMessage(ChatColor.AQUA + "https://www.spigotmc.org/resources/stats-scoreboard.43424/");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        PlayerData playerData = this.plugin.getPlayerData(playerQuitEvent.getPlayer().getUniqueId());
        playerData.getBoard().remove();
    }

    @EventHandler
    public void onWorldChangeEvent(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player paramPlayer = playerChangedWorldEvent.getPlayer();
        ConfigFile configFile = this.plugin.getFileUtil().getConfigFile();
        PlayerData playerData = this.plugin.getPlayerData(paramPlayer.getUniqueId());
        DebugLogger.logDebugMessage("&cWorld Changed.");
        if (!configFile.isDisableCertainWorlds()) {
            DebugLogger.logDebugMessage("&cDisable Worlds is not enabled.");
            return;
        }
        if (!configFile.isScoreboardEnabled()) {
            playerData.getBoard().remove();
            return;
        }
        if (playerData == null) {
            return;
        }
        DebugLogger.logDebugMessage(configFile.getEnabledWorlds().toString());
        if (!Utilities.containsString(paramPlayer.getWorld().getName(), configFile.getEnabledWorlds())) {
            playerData.getBoard().remove();
            return;
        }
        playerData.getBoard().setAllowed(true);
        playerData.getBoard().start();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent playerDeathEvent) {
        try {
            ConfigFile configFile = this.plugin.getFileUtil().getConfigFile();
            Player playerVictim = playerDeathEvent.getEntity();
            if (playerDeathEvent.getEntity().hasMetadata("NPC")) {
                return;
            }
            PlayerData user = this.plugin.getPlayerData(playerVictim.getUniqueId());
            if (configFile.isDisableCertainWorlds() && !Utilities.containsString(playerVictim.getWorld().getName(), configFile.getEnabledWorlds())) {
                return;
            }
            PlayerStatManager statManager = this.plugin.getPlayerStatManager();
            if (playerVictim.getKiller() == null) {
                if (user.getLastHitter() != null) {
                    PlayerData attacker = user.getLastHitter();
                    statManager.addStatAsync(user, attacker, StatType.DEATH, 1);
                    if (user == attacker) {
                        return;
                    }
                    statManager.addStatAsync(attacker, null, StatType.KILL, 1);
                    user.setLastHitter(null);
                    return;
                }
                statManager.addStatAsync(user, user, StatType.DEATH, 1);
                return;
            }
            PlayerData attacker = this.plugin.getPlayerData(playerVictim.getKiller().getUniqueId());
            statManager.addStatAsync(user, attacker, StatType.DEATH, 1);
            if (user == attacker) {
                return;
            }
            statManager.addStatAsync(attacker, null, StatType.KILL, 1);
        }
        catch (Exception ex) {
            DebugLogger.logDebugMessage("Error.PLAYER_DEATH_FAILED_TO_SAVE, " + ex.getMessage());
        }
    }
}

