/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.other;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Primitives;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.extremesnow.datalib.DataManager;
import me.extremesnow.datalib.data.storage.SerializableObject;
import me.extremesnow.datalib.data.storage.SerializedData;
import me.extremesnow.datalib.other.DataPair;

public class Utils {
    private static final List<Class> primitiveList = new ArrayList<Class>(){
        {
            this.add(Integer.class);
            this.add(String.class);
            this.add(Double.class);
            this.add(Long.class);
            this.add(Boolean.class);
            this.add(Float.class);
        }
    };

    public static String formattedAllValue(List<DataPair<String, String>> allValue) {
        StringBuilder sb = new StringBuilder();
        for (DataPair<String, String> value : allValue) {
            sb.append(value.getKey()).append(":").append(value.getValue()).append(" ");
        }
        return sb.toString();
    }

    public static boolean isPrimitive(Class clazz) {
        clazz = Primitives.wrap(clazz);
        return primitiveList.contains(clazz);
    }

    public static JsonElement primitiveToString(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        Class<?> clazz = Primitives.wrap(object.getClass());
        if (clazz == Integer.class) {
            return new JsonPrimitive(object.toString());
        }
        if (clazz == Double.class) {
            return new JsonPrimitive(object.toString());
        }
        if (clazz == Long.class) {
            return new JsonPrimitive(object.toString());
        }
        if (clazz == Float.class) {
            return new JsonPrimitive(object.toString());
        }
        if (clazz == Boolean.class) {
            return new JsonPrimitive((Boolean)object != false ? "1" : "0");
        }
        if (clazz == String.class) {
            return new JsonPrimitive(object.toString());
        }
        throw new IllegalStateException("Failed to serialize object of type " + object.getClass().getSimpleName());
    }

    public static JsonElement wrap(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        if (Utils.isPrimitive(object.getClass())) {
            return Utils.primitiveToString(object);
        }
        if (object instanceof SerializableObject) {
            SerializedData serializedData = new SerializedData();
            ((SerializableObject)object).serialize(serializedData);
            return serializedData.getJsonElement();
        }
        if (object instanceof Collection) {
            JsonArray array = new JsonArray();
            for (Object listObject : (Collection)object) {
                array.add(Utils.wrap(listObject));
            }
            return array;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            JsonArray array = new JsonArray();
            map.forEach((key, value) -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add("key", Utils.wrap(key));
                jsonObject.add("value", Utils.wrap(value));
                array.add(jsonObject);
            });
            return array;
        }
        if (object.getClass().isEnum()) {
            return new JsonPrimitive(((Enum)object).name());
        }
        return DataManager.getInstance().getGson().toJsonTree(object);
    }

    public static String fromElement(JsonElement element) {
        try {
            String elementString = element.getAsString();
            elementString = elementString.replace("\\", "");
            elementString = elementString.replace("\"", "");
            return elementString;
        }
        catch (Throwable throwable) {
            return element.getAsString().replace("\"", "");
        }
    }

    public static Object fromOldElement(JsonElement element) {
        try {
            String elementString = element.getAsString();
            elementString = elementString.replace("\\", "");
            elementString = elementString.replace("\"", "");
            char endsWith = elementString.charAt(elementString.length() - 1);
            String content = elementString.substring(0, elementString.length() - 1);
            if (endsWith == 'i') {
                return Integer.valueOf(content);
            }
            if (endsWith == 'd') {
                return Double.valueOf(content);
            }
            if (endsWith == 'f') {
                return Float.valueOf(content);
            }
            if (endsWith == 'l') {
                return Long.valueOf(content);
            }
            if (endsWith == 'b' && content.length() == 1) {
                return content.toCharArray()[0] != '0';
            }
        }
        catch (Throwable throwable) {
            return element.getAsString();
        }
        return element.getAsString().replace("\"", "");
    }

    public static <T> T fromElement(JsonElement element, Class<T> clazz) {
        if (SerializableObject.class.isAssignableFrom(clazz = Primitives.wrap(clazz))) {
            return Utils.fromSerializable(element.getAsJsonObject(), clazz);
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, element.getAsString());
        }
        Object parsed = Utils.fromElement(element);
        if (clazz != parsed.getClass()) {
            parsed = Utils.doConversion(parsed, clazz);
        }
        return (T)parsed;
    }

    public static <T> T fromOldElement(JsonElement element, Class<T> clazz) {
        if (SerializableObject.class.isAssignableFrom(clazz = Primitives.wrap(clazz))) {
            return Utils.fromSerializable(element.getAsJsonObject(), clazz);
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, element.getAsString());
        }
        Object parsed = Utils.fromOldElement(element);
        if (clazz != Long.class && parsed.getClass() == Long.class) {
            throw new IllegalStateException("Incompatible conversion between " + parsed.getClass().getSimpleName() + " and " + clazz.getSimpleName());
        }
        if (clazz != parsed.getClass()) {
            if (clazz == Boolean.class) {
                throw new IllegalStateException("Incompatible conversion from " + parsed.getClass().getSimpleName() + " to Boolean!");
            }
            parsed = Utils.doConversion(parsed, clazz);
        }
        return (T)parsed;
    }

    private static <T> Object doConversion(Object parsed, Class<T> clazz) {
        String value = parsed.toString();
        value = value.replace("\\", "");
        value = value.replace("\"", "");
        if (clazz == String.class) {
            return value;
        }
        if (clazz == UUID.class) {
            return UUID.fromString(value);
        }
        if (((clazz = Primitives.wrap(clazz)) == Double.class || clazz == Float.class) && Primitives.wrap(clazz) == Integer.class && value.contains(".")) {
            String[] split = value.split("\\.");
            int noZeroCounter = 0;
            for (char c : split[1].toCharArray()) {
                if (c == '0') continue;
                ++noZeroCounter;
            }
            if (noZeroCounter == 0) {
                value = split[0];
            }
        }
        if (clazz == Integer.class) {
            return Integer.parseInt(value);
        }
        if (clazz == Boolean.class) {
            return value.toCharArray()[0] != '0';
        }
        if (clazz == Long.class) {
            return Long.parseLong(value);
        }
        if (clazz == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz == Double.class) {
            return Double.parseDouble(value);
        }
        throw new IllegalStateException("Failed to convert " + parsed.getClass().getSimpleName() + " to " + clazz.getSimpleName() + " unknown conversion!");
    }

    public static <T> T fromSerializable(JsonObject jsonObject, Class<T> clazz) {
        Object object = Utils.getConstructor(clazz).newInstance(new Object[0]);
        ((SerializableObject)object).deserialize(new SerializedData(jsonObject));
        return object;
    }

    public static Constructor getConstructor(Class clazz) {
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor;
    }
}

