/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.other;

import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import me.extremesnow.datalib.other.ThrowableConsumer;

public class ConnectionWrapper {
    @NonNull
    private final Connection connection;
    @NonNull
    private final Consumer<Connection> onEvict;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionWrapper use(ThrowableConsumer<Connection> user) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                user.accept(this.connection);
                ConnectionWrapper connectionWrapper = this;
                return connectionWrapper;
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to use connection", throwable);
            }
            finally {
                this.evict();
            }
        }
    }

    public ConnectionWrapper useNonLock(ThrowableConsumer<Connection> user) {
        try {
            user.accept(this.connection);
            ConnectionWrapper connectionWrapper = this;
            return connectionWrapper;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to use connection", throwable);
        }
        finally {
            this.evict();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T provideAndEvict(Function<Connection, T> provider) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Connection t = provider.apply(this.connection);
                return (T)t;
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to use connection", throwable);
            }
            finally {
                this.evict();
            }
        }
    }

    public void evict() {
        this.onEvict.accept(this.connection);
    }

    public ConnectionWrapper(@NonNull Connection connection, @NonNull Consumer<Connection> onEvict) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (onEvict == null) {
            throw new NullPointerException("onEvict is marked non-null but is null");
        }
        this.connection = connection;
        this.onEvict = onEvict;
    }

    @NonNull
    public Connection getConnection() {
        return this.connection;
    }
}

