/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.jobs;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.extremesnow.datalib.jobs.Job;
import me.extremesnow.datalib.jobs.JobsResult;

public class JobsRunner {
    private final Set<CompletableFuture<Void>> jobs = ConcurrentHashMap.newKeySet();
    private final Set<Throwable> errors = ConcurrentHashMap.newKeySet();

    protected JobsRunner() {
    }

    public static JobsRunner acquire() {
        return new JobsRunner();
    }

    public JobsRunner addJob(Job job) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(job);
        future.whenComplete(($, error) -> {
            if (error == null) {
                return;
            }
            this.errors.add((Throwable)error);
        });
        this.jobs.add(future);
        return this;
    }

    public JobsResult startAndWait() {
        if (this.jobs.isEmpty()) {
            return new JobsResult(this.errors, new AtomicInteger(0));
        }
        CompletableFuture.allOf(this.jobs.toArray(new CompletableFuture[0])).get(1L, TimeUnit.MINUTES);
        return new JobsResult(this.errors, new AtomicInteger(this.jobs.size() - this.errors.size()));
    }
}

