/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.table;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import me.extremesnow.datalib.data.AbstractSQL;
import me.extremesnow.datalib.other.DataPair;

public class TableEditor {
    private final String table;
    private final List<DataPair<String, String>> addColumns = new ArrayList<DataPair<String, String>>();
    private final List<String> dropsColumns = new ArrayList<String>();
    private final List<DataPair<String, String>> renamedColumns = new ArrayList<DataPair<String, String>>();

    public TableEditor addColumn(String name, String type) {
        this.addColumns.add(new DataPair<String, String>(name, type));
        return this;
    }

    public TableEditor addDropColumn(String column) {
        this.dropsColumns.add(column);
        return this;
    }

    public TableEditor renameColumn(String oldColumnName, String newColumnName) {
        this.renamedColumns.add(new DataPair<String, String>(oldColumnName, newColumnName));
        return this;
    }

    public void edit(AbstractSQL database) {
        if (!database.getTables().contains(this.table)) {
            return;
        }
        for (DataPair<String, String> column : this.addColumns) {
            List<String> columns = database.getColumns();
            if (columns.contains(column.getKey())) continue;
            try {
                String query = "ALTER TABLE `" + this.table + "` ADD `" + column.getKey() + "` " + column.getValue();
                database.executeQuery(query, true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (!this.renamedColumns.isEmpty()) {
            database.renameColumn(this.table, this.renamedColumns.toArray(new DataPair[0]));
        }
        if (!this.dropsColumns.isEmpty()) {
            database.dropColumn(this.table, this.dropsColumns.toArray(new String[0]));
        }
    }

    public TableEditor(String table) {
        this.table = table;
    }
}

