/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.table;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import me.extremesnow.datalib.data.AbstractSQL;
import me.extremesnow.datalib.data.mysql.old.MySQLOldDatabase;
import me.extremesnow.datalib.data.table.ColumnType;
import me.extremesnow.datalib.other.DataPair;

public class TableCreator {
    private final AbstractSQL database;
    private String tableName;
    private DataPair<String, String> primaryKey;
    private final List<DataPair<String, String>> columns = new LinkedList<DataPair<String, String>>();

    public TableCreator(AbstractSQL database) {
        this.database = database;
    }

    public TableCreator setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableCreator addColumn(String columnName, ColumnType columnType) {
        return this.addColumn(columnName, columnType.getSql());
    }

    public TableCreator addColumn(String columnName, String columnType) {
        this.columns.add(new DataPair<String, String>(columnName, columnType));
        return this;
    }

    public TableCreator primaryKey(String column, ColumnType columnType) {
        return this.primaryKey(column, columnType.getSql());
    }

    public TableCreator primaryKey(String column, String columnType) {
        this.primaryKey = new DataPair<String, String>(column, columnType);
        return this;
    }

    public AbstractSQL create() {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("CREATE TABLE IF NOT EXISTS ").append(this.tableName).append(" (");
        if (this.primaryKey != null) {
            if (this.database.getType().equalsIgnoreCase("SQLITE")) {
                queryBuilder.append(this.primaryKey.getKey()).append(" ").append(this.primaryKey.getValue()).append(" PRIMARY KEY, ");
            } else {
                queryBuilder.append(this.primaryKey.getKey()).append(" VARCHAR(255)").append(", ");
            }
        }
        boolean first = true;
        for (DataPair<String, String> columnPair : this.columns) {
            if (first) {
                queryBuilder.append(columnPair.getKey()).append(" ").append(columnPair.getValue());
                first = false;
                continue;
            }
            queryBuilder.append(", ").append(columnPair.getKey()).append(" ").append(columnPair.getValue());
        }
        if (this.primaryKey != null && !this.database.getType().equalsIgnoreCase("SQLITE")) {
            queryBuilder.append(", PRIMARY KEY (").append(this.primaryKey.getKey()).append(")");
        }
        queryBuilder.append(") ");
        if (this.database instanceof MySQLOldDatabase) {
            queryBuilder.append("character set latin1;");
        }
        try {
            this.database.executeQuery(queryBuilder.toString(), true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.database;
    }
}

