/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.extremesnow.datalib.DataManager;
import me.extremesnow.datalib.data.AbstractSQL;
import me.extremesnow.datalib.data.mysql.MySQLDatabase;
import me.extremesnow.datalib.data.mysql.old.MySQLOldDatabase;
import me.extremesnow.datalib.data.sqlite.SQLiteDatabase;
import me.extremesnow.datalib.data.sqlite.old.SQLiteOldDatabase;
import me.extremesnow.datalib.data.storage.DataObject;
import me.extremesnow.datalib.data.storage.ModelCachedData;
import me.extremesnow.datalib.data.storage.OldSerializedObject;
import me.extremesnow.datalib.data.storage.SerializedData;
import me.extremesnow.datalib.data.storage.Storage;
import me.extremesnow.datalib.data.table.ColumnType;
import me.extremesnow.datalib.data.table.TableCreator;
import me.extremesnow.datalib.data.table.TableEditor;
import me.extremesnow.datalib.other.DataDebugLog;
import me.extremesnow.datalib.other.DataPair;
import me.extremesnow.datalib.other.Utils;

public abstract class StorageHolder<T extends DataObject>
extends Storage<T> {
    private final AbstractSQL database;
    private final Map<String, List<String>> loadedTableStructures = new HashMap<String, List<String>>();

    public StorageHolder(AbstractSQL database) {
        this.database = database;
    }

    private boolean confirmTable(T object) {
        if (!this.database.getTables().contains(this.database.getDbTable())) {
            Class variant = this.getVariants().get(this.database.getDbTable());
            Object t = this.construct(variant);
            TableCreator tableCreator = new TableCreator(this.database).setTableName(this.database.getDbTable()).primaryKey(((DataObject)t).getStructure()[0], ColumnType.VARCHAR);
            for (String column2 : Arrays.copyOfRange(((DataObject)t).getStructure(), 1, ((DataObject)t).getStructure().length)) {
                tableCreator.addColumn(column2, ColumnType.TEXT);
            }
            tableCreator.create();
            return true;
        }
        if (this.database.getColumns().size() != ((DataObject)object).getStructure().length) {
            TableEditor editor = new TableEditor(this.database.getDbTable());
            Arrays.stream(((DataObject)object).getStructure()).filter(column -> !this.database.getColumns().contains(column)).forEach(column -> editor.addColumn((String)column, ColumnType.TEXT.getSql()));
            editor.edit(this.database);
        }
        return true;
    }

    @Override
    public synchronized void save(T object, boolean async, Runnable callback) {
        Consumer<Runnable> runner = DataManager.getInstance().getRunner(async);
        runner.accept(() -> {
            if (!this.confirmTable(object)) {
                return;
            }
            SerializedData data = new SerializedData();
            object.serialize(data);
            JsonObject jsonObject = data.getJsonElement().getAsJsonObject();
            JsonElement[] jsonElements = new JsonElement[object.getStructure().length];
            for (int i = 0; i < object.getStructure().length; ++i) {
                JsonElement element = jsonObject.get(object.getStructure()[i]);
                jsonElements[i] = Objects.requireNonNull(element, "Failed to find '" + object.getStructure()[i] + "' field inside serialized data of " + object.getClass().getName());
            }
            String primaryKey = object.getKey();
            if (this.database.isPrimaryKeyUsed(this.database.getDbTable(), object.getStructure(), primaryKey)) {
                this.updateObject(object, primaryKey, jsonObject);
            } else {
                this.insertObject(object, primaryKey, jsonObject);
            }
        });
    }

    public void load() {
        this.load(true);
    }

    public void load(boolean async) {
        Consumer<Runnable> runner = DataManager.getInstance().getRunner(async);
        if (this.database instanceof SQLiteOldDatabase || this.database instanceof MySQLOldDatabase) {
            this.loadOldOOPDataModuleTable(runner);
            return;
        }
        runner.accept(() -> {
            for (Class clazz : this.getVariants().values()) {
                Object dummy = this.construct(clazz);
                this.confirmTable(dummy);
                List<List<DataPair<String, String>>> allValues = this.getAllValuesOf(this.database.getDbTable(), ((DataObject)dummy).getStructure());
                for (List<DataPair<String, String>> allValue : allValues) {
                    JsonObject object = this.toJson(allValue);
                    SerializedData data = new SerializedData(object);
                    try {
                        Object t = this.construct(clazz);
                        t.deserialize(data);
                        this.onAdd(t);
                        this.loadObjectCache(((DataObject)t).getKey(), data);
                    }
                    catch (Throwable exception) {
                        System.out.println("Failed to deserialize class, with data: " + Utils.formattedAllValue(allValue));
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    public void save(boolean async, Runnable callback) {
        Consumer<Runnable> runner = DataManager.getInstance().getRunner(async);
        runner.accept(() -> {
            for (DataObject object : this) {
                SerializedData data = new SerializedData();
                object.serialize(data);
                JsonObject jsonObject = data.getJsonElement().getAsJsonObject();
                JsonElement[] jsonElements = new JsonElement[object.getStructure().length];
                for (int i = 0; i < object.getStructure().length; ++i) {
                    JsonElement element = jsonObject.get(object.getStructure()[i]);
                    jsonElements[i] = Objects.requireNonNull(element, "Failed to find '" + object.getStructure()[i] + "' field inside serialized data of " + object.getClass().getName());
                }
                String primaryKey = object.getKey();
                if (this.database.isPrimaryKeyUsed(this.database.getDbTable(), object.getStructure(), primaryKey)) {
                    this.updateObject(object, primaryKey, jsonObject);
                    continue;
                }
                this.insertObject(object, primaryKey, jsonObject);
            }
            if (callback != null) {
                callback.run();
            }
        });
    }

    public void save(boolean async) {
        this.save(async, null);
    }

    private synchronized void insertObject(T object, String primaryKey, JsonObject jsonObject) {
        ModelCachedData cache = new ModelCachedData();
        this.getDataCache().put(primaryKey, cache);
        this.getDatabase().getConnection().use(conn -> {
            try (PreparedStatement stmt = conn.prepareStatement(this.createInsertStatement(this.database.getDbTable(), object));){
                for (int i = 0; i < object.getStructure().length; ++i) {
                    String column = object.getStructure()[i];
                    String serializedData = jsonObject.get(column).toString().replace("\"", "");
                    cache.add(column, serializedData);
                    stmt.setString(i + 1, serializedData);
                }
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }).evict();
    }

    private String createInsertStatement(String tableName, T object) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(tableName).append(" (").append(Arrays.stream(((DataObject)object).getStructure()).collect(Collectors.joining(","))).append(") VALUES (");
        builder.append(Arrays.stream(((DataObject)object).getStructure()).map(s -> "?").collect(Collectors.joining(",")));
        builder.append(")");
        return builder.toString();
    }

    private void updateObject(T object, String primaryKey, JsonObject jsonObject) {
        ModelCachedData cache = this.getDataCache().computeIfAbsent(primaryKey, key -> new ModelCachedData());
        String[] structure = ((DataObject)object).getStructure();
        ArrayList<DataPair<String, String>> needsUpdate = new ArrayList<DataPair<String, String>>();
        for (String struct : structure) {
            JsonElement element = jsonObject.get(struct);
            String serializedData = element.toString().replace("\"", "");
            if (!cache.isUpdated(struct, serializedData)) continue;
            DataDebugLog.logDebug("Needs Update: " + struct + " " + element);
            needsUpdate.add(new DataPair<String, String>(struct, serializedData));
        }
        if (needsUpdate.isEmpty()) {
            DataDebugLog.logDebug("Needs update is empty. no need for updating");
            return;
        }
        this.getDatabase().getConnection().use(conn -> {
            try (PreparedStatement stmt = conn.prepareStatement(this.createUpdateStatement(this.database.getDbTable(), object.getStructure()[0], needsUpdate.stream().map(DataPair::getKey).collect(Collectors.toList())));){
                int currentIndex = 1;
                for (DataPair dataPair : needsUpdate) {
                    String value = ((String)dataPair.getValue()).replace("\"", "");
                    stmt.setString(currentIndex, value);
                    ++currentIndex;
                }
                stmt.setString(currentIndex, primaryKey);
                DataDebugLog.logDebug("Needs update is empty. no need for updating");
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }).evict();
    }

    protected String createUpdateStatement(String table, String pkColumn, List<String> columns) {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append(table).append(" SET ");
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(column).append(" = ?");
        }
        builder.append(" WHERE ").append(pkColumn).append(" = ?");
        return builder.toString();
    }

    private String createInsertAndUpdateStatement(String tableName, T object, List<String> columns) {
        CharSequence[] structure = ((DataObject)object).getStructure();
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(tableName).append(" (").append(String.join((CharSequence)", ", structure)).append(") VALUES (").append(Arrays.stream(structure).map(s -> "?").collect(Collectors.joining(", "))).append(") ");
        if (this.database instanceof MySQLDatabase) {
            builder.append("ON DUPLICATE KEY UPDATE ");
        } else {
            builder.append("ON CONFLICT (").append(((DataObject)object).getStructure()[0]).append(") DO UPDATE SET ");
        }
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(column).append(" = ?");
        }
        if (this.database instanceof SQLiteDatabase) {
            builder.append(" WHERE ").append(((DataObject)object).getStructure()[0]).append(" = ?");
        }
        return builder.toString();
    }

    private JsonObject toJson(List<DataPair<String, String>> objectValues) {
        JsonObject object = new JsonObject();
        for (DataPair<String, String> objectValue : objectValues) {
            String key = objectValue.getKey();
            JsonElement value = null;
            try {
                value = DataManager.getInstance().getGson().fromJson(objectValue.getValue(), JsonElement.class);
            }
            catch (Exception e) {
                DataDebugLog.logDebug("Faultly Gson element. Attempting to set a default value instead.");
            }
            object.add(key, value);
        }
        return object;
    }

    public synchronized List<List<DataPair<String, String>>> getAllValuesOf(String table, String[] structure) {
        LinkedList<List<DataPair<String, String>>> allData = new LinkedList<List<DataPair<String, String>>>();
        this.database.getConnection().use(conn -> {
            try (ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + table);){
                while (rs.next()) {
                    int i = 1;
                    LinkedList<DataPair<String, String>> data = new LinkedList<DataPair<String, String>>();
                    for (String column : structure) {
                        data.add(new DataPair<String, String>(rs.getMetaData().getColumnName(i), rs.getString(i)));
                        ++i;
                    }
                    allData.add(data);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        return allData;
    }

    private void confirmStructure(String table) {
        try {
            List<String> columns = this.database.getColumns();
            this.loadedTableStructures.put(table, columns);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadOldOOPDataModuleTable(Consumer<Runnable> runner) {
        runner.accept(() -> {
            for (Class clazz : this.getVariants().values()) {
                boolean needsTreatment;
                String[] structure;
                Object dummy = this.construct(clazz);
                this.confirmTable(dummy);
                if (this.database instanceof SQLiteOldDatabase) {
                    structure = ((SQLiteOldDatabase)this.database).getCredential().needsSpecialTreatment() ? ((OldSerializedObject)dummy).oldStructure() : ((DataObject)dummy).getStructure();
                    needsTreatment = ((SQLiteOldDatabase)this.database).getCredential().needsSpecialTreatment();
                } else {
                    structure = ((MySQLOldDatabase)this.database).getCredential().needsSpecialTreatment() ? ((OldSerializedObject)dummy).oldStructure() : ((DataObject)dummy).getStructure();
                    needsTreatment = ((MySQLOldDatabase)this.database).getCredential().needsSpecialTreatment();
                }
                List<List<DataPair<String, String>>> allValues = this.getAllValuesOf(this.database.getDbTable(), structure);
                for (List<DataPair<String, String>> allValue : allValues) {
                    JsonObject object = this.toJson(allValue);
                    SerializedData data = new SerializedData(object);
                    try {
                        Object t = this.construct(clazz);
                        if (needsTreatment) {
                            ((OldSerializedObject)t).deserializeLite(data);
                        } else {
                            ((OldSerializedObject)t).deserializeOld(data);
                        }
                        this.onAdd(t);
                        this.loadObjectCache(((DataObject)t).getKey(), data);
                    }
                    catch (Throwable exception) {
                        System.out.println("Failed to deserialize class, with data: " + Utils.formattedAllValue(allValue));
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    public static <T> List<T> reverseList(List<T> list) {
        ArrayList<T> reverse = new ArrayList<T>(list);
        Collections.reverse(reverse);
        return reverse;
    }

    public AbstractSQL getDatabase() {
        return this.database;
    }

    public Map<String, List<String>> getLoadedTableStructures() {
        return this.loadedTableStructures;
    }
}

