/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.extremesnow.datalib.data.storage.DataObject;
import me.extremesnow.datalib.data.storage.ModelCachedData;
import me.extremesnow.datalib.data.storage.SerializedData;

public abstract class Storage<T extends DataObject>
implements Iterable<T> {
    private final Map<String, Class<T>> variants = new HashMap<String, Class<T>>();
    private final Map<Class<? extends T>, Constructor<? extends T>> constructorMap = new ConcurrentHashMap<Class<? extends T>, Constructor<? extends T>>();
    private final Map<String, ModelCachedData> dataCache = new ConcurrentHashMap<String, ModelCachedData>();

    public void addVariant(String variant, Class<T> clazz) {
        this.variants.put(variant, clazz);
    }

    protected abstract void onAdd(T var1);

    protected abstract void onRemove(T var1);

    public void add(T object) {
        this.onAdd(object);
        this.save(object, true, null);
    }

    protected void loadObjectCache(String key, SerializedData data) {
        ModelCachedData modelCachedData = this.dataCache.computeIfAbsent(key, k -> new ModelCachedData());
        modelCachedData.clear();
        JsonObject jsonObject = data.getJsonElement().getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            modelCachedData.add(entry.getKey(), entry.getValue().toString());
        }
    }

    public boolean isObjectUpdated(T object) {
        SerializedData data = new SerializedData();
        object.serialize(data);
        return this.isObjectUpdated(((DataObject)object).getKey(), data);
    }

    public boolean isObjectUpdated(String key, SerializedData data) {
        ModelCachedData modelCachedData = this.dataCache.computeIfAbsent(key, k -> new ModelCachedData());
        if (modelCachedData.isEmpty()) {
            return true;
        }
        JsonObject jsonObject = data.getJsonElement().getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            if (!modelCachedData.isUpdated(entry.getKey(), entry.getValue().toString())) continue;
            return true;
        }
        return false;
    }

    public void remove(T object) {
        this.onRemove(object);
    }

    public abstract void save(T var1, boolean var2, Runnable var3);

    public abstract void batchSave(List<T> var1, boolean var2, Runnable var3);

    public <B extends T> B construct(Class<B> clazz) {
        return (B)((DataObject)this.constructorMap.computeIfAbsent(clazz, key -> {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to find empty constructor for " + clazz);
            }
        }).newInstance(new Object[0]));
    }

    public Map<String, Class<T>> getVariants() {
        return this.variants;
    }

    protected Map<Class<? extends T>, Constructor<? extends T>> getConstructorMap() {
        return this.constructorMap;
    }

    protected Map<String, ModelCachedData> getDataCache() {
        return this.dataCache;
    }
}

