/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.extremesnow.datalib.other.DataPair;
import me.extremesnow.datalib.other.Preconditions;
import me.extremesnow.datalib.other.Utils;

public class SerializedData {
    private final JsonElement jsonElement;

    public SerializedData() {
        this(new JsonObject());
    }

    public SerializedData(JsonElement jsonElement) {
        this.jsonElement = jsonElement;
    }

    public <T> T applyAs(String field, Class<T> clazz, Supplier<T> def) {
        return (T)this.getElement(field).map(element -> Utils.fromElement(element, clazz)).orElseGet(def == null ? () -> null : def);
    }

    public <T> T applyAsFromOld(String field, Class<T> clazz, Supplier<T> def) {
        return (T)this.getElement(field).map(element -> Utils.fromOldElement(element, clazz)).orElseGet(def == null ? () -> null : def);
    }

    public <T> T applyAsFromOld(String field, Class<T> clazz) {
        return this.applyAsFromOld(field, clazz, null);
    }

    public boolean has(String field) {
        return this.funcJsonObject(jo -> jo.has(field) && jo.get(field) != JsonNull.INSTANCE, () -> false);
    }

    public <T> T applyAs(String field, Class<T> clazz) {
        return this.applyAs(field, clazz, null);
    }

    public Optional<SerializedData> getChildren(String field) {
        return this.getElement(field).map(SerializedData::new);
    }

    public Optional<JsonElement> getElement(String field) {
        Preconditions.checkArgument(this.jsonElement.isJsonObject(), "Failed to get element cause it's not an JsonObject");
        JsonElement element = this.jsonElement.getAsJsonObject().get(field);
        return element == null || element == JsonNull.INSTANCE ? Optional.empty() : Optional.of(element);
    }

    public void write(String field, Object object) {
        Preconditions.checkArgument(this.jsonElement.isJsonObject(), "You cannot set a field in JsonElement!");
        this.consumeJsonObject(jo -> {
            JsonElement wrap = Utils.wrap(object);
            jo.add(field, wrap);
        });
    }

    private void consumeJsonObject(Consumer<JsonObject> consumer) {
        if (this.jsonElement.isJsonObject()) {
            consumer.accept(this.jsonElement.getAsJsonObject());
        }
    }

    public <T> T funcJsonObject(Function<JsonObject, T> function, Supplier<T> def) {
        if (this.jsonElement.isJsonObject()) {
            return function.apply(this.jsonElement.getAsJsonObject());
        }
        return null;
    }

    public SerializedData fromQuery(List<DataPair<String, String>> objectValues) {
        SerializedData object = new SerializedData();
        for (DataPair<String, String> objectValue : objectValues) {
            object.write(objectValue.getKey(), objectValue.getValue());
        }
        return object;
    }

    public JsonElement getJsonElement() {
        return this.jsonElement;
    }
}

