/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.sqlite.old;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import me.extremesnow.datalib.data.HikariCPDatabase;
import me.extremesnow.datalib.data.sqlite.old.SQLiteOldCredential;
import me.extremesnow.datalib.other.DataPair;

public class SQLiteOldDatabase
extends HikariCPDatabase {
    private final SQLiteOldCredential credential;
    private final String path;

    public SQLiteOldDatabase(SQLiteOldCredential credential, String path) {
        super(credential.getTable());
        this.credential = credential;
        this.path = path;
        HikariConfig config = new HikariConfig();
        config.setPoolName("AL-SQLite-Pool");
        config.setDriverClassName("org.sqlite.JDBC");
        config.setJdbcUrl(credential.toURL());
        config.setConnectionTestQuery("SELECT 1");
        config.setMaxLifetime(60000L);
        config.setMaximumPoolSize(30);
        config.setConnectionTimeout(120000L);
        this.setDbSource(new HikariDataSource(config));
    }

    @Override
    public String getType() {
        return "SQLITE";
    }

    @Override
    public void renameColumn(String table, DataPair<String, String> ... pairs) {
    }

    @Override
    public void dropColumn(String table, String ... columns) {
    }

    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS " + this.credential.getTable() + " (\n\tid integer PRIMARY KEY,\n\tname text NOT NULL,\n\tcapacity real\n);";
        try {
            this.executeQuery(sql, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public SQLiteOldCredential getCredential() {
        return this.credential;
    }
}

