/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.sqlite.old;

import java.io.File;
import me.extremesnow.datalib.data.SQLCredential;
import me.extremesnow.datalib.data.sqlite.old.SQLiteOldDatabase;

public class SQLiteOldCredential
implements SQLCredential {
    private File folder;
    private String database;
    private String table;
    private SQLiteOldDatabase sqlLiteDatabase;
    private boolean needsTreatment = false;

    public SQLiteOldCredential(File folder, String database, String table) {
        this.folder = folder;
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.database = database;
        this.table = table;
    }

    @Override
    public SQLiteOldDatabase build() {
        if (this.sqlLiteDatabase != null) {
            return this.sqlLiteDatabase;
        }
        return new SQLiteOldDatabase(this, this.folder.getPath());
    }

    @Override
    public boolean needsSpecialTreatment() {
        return this.needsTreatment;
    }

    @Override
    public void setNeedsSpecialTreatment(boolean bool) {
        this.needsTreatment = bool;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    public String toURL() {
        String url = "jdbc:sqlite:" + this.folder.getAbsolutePath() + File.separator + this.database + ".db";
        return url;
    }

    public boolean test() {
        try {
            SQLiteOldDatabase build = this.build();
            build.getConnection().use(conn -> {});
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("SQLite database test failed...", throwable);
        }
        System.out.println("Test Complete. Connection Successful");
        return true;
    }

    public SQLiteOldCredential folder(File folder) {
        this.folder = folder;
        return this;
    }

    public SQLiteOldCredential database(String database) {
        this.database = database;
        return this;
    }

    public SQLiteOldCredential table(String table) {
        this.table = table;
        return this;
    }

    public SQLiteOldCredential sqlLiteDatabase(SQLiteOldDatabase sqlLiteDatabase) {
        this.sqlLiteDatabase = sqlLiteDatabase;
        return this;
    }

    public SQLiteOldCredential needsTreatment(boolean needsTreatment) {
        this.needsTreatment = needsTreatment;
        return this;
    }

    public File folder() {
        return this.folder;
    }

    public String database() {
        return this.database;
    }

    public String table() {
        return this.table;
    }

    public SQLiteOldDatabase sqlLiteDatabase() {
        return this.sqlLiteDatabase;
    }

    public boolean needsTreatment() {
        return this.needsTreatment;
    }
}

