/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.sqlite;

import java.io.File;
import me.extremesnow.datalib.data.SQLCredential;
import me.extremesnow.datalib.data.sqlite.SQLiteDatabase;

public class SQLiteCredential
implements SQLCredential {
    private File folder;
    private String database;
    private String table;
    private SQLiteDatabase sqlLiteDatabase;
    private boolean needsTreatment;

    public SQLiteCredential(File folder, String database, String table) {
        this.folder = folder;
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.database = database;
        this.table = table;
    }

    @Override
    public SQLiteDatabase build() {
        if (this.sqlLiteDatabase != null) {
            return this.sqlLiteDatabase;
        }
        return new SQLiteDatabase(this, this.folder.getPath());
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public boolean needsSpecialTreatment() {
        return this.needsTreatment;
    }

    @Override
    public void setNeedsSpecialTreatment(boolean bool) {
        this.needsTreatment = bool;
    }

    public String toURL() {
        String url = "jdbc:sqlite:" + this.folder.getAbsolutePath() + File.separator + this.database + ".db";
        return url;
    }

    public boolean test() {
        try {
            SQLiteDatabase build = this.build();
            build.getConnection().use(conn -> {});
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("SQLite database test failed...", throwable);
        }
        System.out.println("Test Complete. Connection Successful");
        return true;
    }

    public SQLiteCredential folder(File folder) {
        this.folder = folder;
        return this;
    }

    public SQLiteCredential database(String database) {
        this.database = database;
        return this;
    }

    public SQLiteCredential table(String table) {
        this.table = table;
        return this;
    }

    public SQLiteCredential sqlLiteDatabase(SQLiteDatabase sqlLiteDatabase) {
        this.sqlLiteDatabase = sqlLiteDatabase;
        return this;
    }

    public SQLiteCredential needsTreatment(boolean needsTreatment) {
        this.needsTreatment = needsTreatment;
        return this;
    }

    public File folder() {
        return this.folder;
    }

    public String database() {
        return this.database;
    }

    public String table() {
        return this.table;
    }

    public SQLiteDatabase sqlLiteDatabase() {
        return this.sqlLiteDatabase;
    }

    public boolean needsTreatment() {
        return this.needsTreatment;
    }
}

