/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.mysql.old;

import me.extremesnow.datalib.data.SQLCredential;
import me.extremesnow.datalib.data.mysql.old.MySQLOldDatabase;

public class MySQLOldCredential
implements SQLCredential {
    private String database;
    private String hostname;
    private int port = 3306;
    private String username;
    private String password;
    private boolean useSSL = false;
    private boolean allowPublicKeyRetrieval = true;
    private String table;
    private boolean needsTreatment = false;
    private MySQLOldDatabase mySQLDatabase;

    @Override
    public MySQLOldDatabase build() {
        if (this.mySQLDatabase != null) {
            return this.mySQLDatabase;
        }
        return new MySQLOldDatabase(this);
    }

    public String toURL() {
        String url = "jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database;
        url = url + "?allowPublicKeyRetrieval=" + this.allowPublicKeyRetrieval + "&useSSL=" + this.useSSL;
        return url;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public boolean needsSpecialTreatment() {
        return this.needsTreatment;
    }

    @Override
    public void setNeedsSpecialTreatment(boolean bool) {
        this.needsTreatment = bool;
    }

    public boolean test() {
        try {
            MySQLOldDatabase build = this.build();
            build.getConnection().use(conn -> {}).evict();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("MySQL database test failed...", throwable);
        }
        return true;
    }

    public MySQLOldCredential database(String database) {
        this.database = database;
        return this;
    }

    public MySQLOldCredential hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MySQLOldCredential port(int port) {
        this.port = port;
        return this;
    }

    public MySQLOldCredential username(String username) {
        this.username = username;
        return this;
    }

    public MySQLOldCredential password(String password) {
        this.password = password;
        return this;
    }

    public MySQLOldCredential useSSL(boolean useSSL) {
        this.useSSL = useSSL;
        return this;
    }

    public MySQLOldCredential allowPublicKeyRetrieval(boolean allowPublicKeyRetrieval) {
        this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
        return this;
    }

    public MySQLOldCredential table(String table) {
        this.table = table;
        return this;
    }

    public MySQLOldCredential needsTreatment(boolean needsTreatment) {
        this.needsTreatment = needsTreatment;
        return this;
    }

    public MySQLOldCredential mySQLDatabase(MySQLOldDatabase mySQLDatabase) {
        this.mySQLDatabase = mySQLDatabase;
        return this;
    }

    public String database() {
        return this.database;
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public boolean allowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    public String table() {
        return this.table;
    }

    public boolean needsTreatment() {
        return this.needsTreatment;
    }

    public MySQLOldDatabase mySQLDatabase() {
        return this.mySQLDatabase;
    }
}

