/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.mysql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import me.extremesnow.datalib.data.HikariCPDatabase;
import me.extremesnow.datalib.data.mysql.MySQLCredential;
import me.extremesnow.datalib.other.DataPair;

public class MySQLDatabase
extends HikariCPDatabase {
    private final MySQLCredential credential;

    public MySQLDatabase(MySQLCredential credential) {
        super(credential.getTable());
        this.credential = credential;
        HikariConfig config = new HikariConfig();
        config.setPoolName("AL-MySQL-Pool");
        config.setDriverClassName("com.mysql.jdbc.Driver");
        config.setJdbcUrl(credential.toURL());
        config.setUsername(credential.username());
        config.setPassword(credential.password());
        config.addDataSourceProperty("cachePrepStmts", true);
        config.addDataSourceProperty("prepStmtCacheSize", 250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
        config.addDataSourceProperty("useServerPrepStmts", true);
        config.addDataSourceProperty("useLocalSessionState", true);
        config.addDataSourceProperty("rewriteBatchedStatements", true);
        config.addDataSourceProperty("cacheResultSetMetadata", true);
        config.addDataSourceProperty("cacheServerConfiguration", true);
        config.addDataSourceProperty("elideSetAutoCommits", true);
        config.addDataSourceProperty("maintainTimeStats", false);
        config.addDataSourceProperty("alwaysSendSetIsolation", false);
        config.addDataSourceProperty("cacheCallableStmts", true);
        config.setConnectionTimeout(120000L);
        config.setMaximumPoolSize(40);
        this.setDbSource(new HikariDataSource(config));
    }

    @Override
    public String getType() {
        return "MYSQL";
    }

    @Override
    public void renameColumn(String table, DataPair<String, String> ... pairs) {
    }

    @Override
    public void dropColumn(String table, String ... columns) {
    }

    public MySQLCredential getCredential() {
        return this.credential;
    }
}

