/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data.mysql;

import me.extremesnow.datalib.data.SQLCredential;
import me.extremesnow.datalib.data.mysql.MySQLDatabase;

public class MySQLCredential
implements SQLCredential {
    private String database;
    private String hostname;
    private int port = 3306;
    private String username;
    private String password;
    private boolean useSSL = false;
    private boolean allowPublicKeyRetrieval = true;
    private boolean needsTreatment = false;
    private String table;
    private MySQLDatabase mySQLDatabase;

    @Override
    public MySQLDatabase build() {
        if (this.mySQLDatabase != null) {
            return this.mySQLDatabase;
        }
        return new MySQLDatabase(this);
    }

    public String toURL() {
        String url = "jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database;
        url = url + "?allowPublicKeyRetrieval=" + this.allowPublicKeyRetrieval + "&useSSL=" + this.useSSL;
        return url;
    }

    @Override
    public boolean needsSpecialTreatment() {
        return this.needsTreatment;
    }

    @Override
    public void setNeedsSpecialTreatment(boolean bool) {
        this.needsTreatment = bool;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    public boolean test() {
        try {
            MySQLDatabase build = this.build();
            build.getConnection().use(conn -> {}).evict();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("MySQL database test failed...", throwable);
        }
        return true;
    }

    public MySQLCredential database(String database) {
        this.database = database;
        return this;
    }

    public MySQLCredential hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MySQLCredential port(int port) {
        this.port = port;
        return this;
    }

    public MySQLCredential username(String username) {
        this.username = username;
        return this;
    }

    public MySQLCredential password(String password) {
        this.password = password;
        return this;
    }

    public MySQLCredential useSSL(boolean useSSL) {
        this.useSSL = useSSL;
        return this;
    }

    public MySQLCredential allowPublicKeyRetrieval(boolean allowPublicKeyRetrieval) {
        this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
        return this;
    }

    public MySQLCredential needsTreatment(boolean needsTreatment) {
        this.needsTreatment = needsTreatment;
        return this;
    }

    public MySQLCredential table(String table) {
        this.table = table;
        return this;
    }

    public MySQLCredential mySQLDatabase(MySQLDatabase mySQLDatabase) {
        this.mySQLDatabase = mySQLDatabase;
        return this;
    }

    public String database() {
        return this.database;
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public boolean allowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    public boolean needsTreatment() {
        return this.needsTreatment;
    }

    public String table() {
        return this.table;
    }

    public MySQLDatabase mySQLDatabase() {
        return this.mySQLDatabase;
    }
}

