/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import lombok.NonNull;
import me.extremesnow.datalib.data.AbstractSQL;

public abstract class HikariCPDatabase
extends AbstractSQL {
    @NonNull
    private HikariDataSource dbSource;

    public HikariCPDatabase(String dbTable) {
        super(dbTable);
    }

    @Override
    protected Connection provideConnection() {
        return this.dbSource.getConnection();
    }

    @Override
    public void shutdown() {
        if (this.dbSource != null) {
            this.dbSource.close();
        }
    }

    @Override
    public void evict(Connection connection) {
        connection.close();
    }

    protected void setDbSource(@NonNull HikariDataSource dbSource) {
        if (dbSource == null) {
            throw new NullPointerException("dbSource is marked non-null but is null");
        }
        this.dbSource = dbSource;
    }
}

