/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import me.extremesnow.datalib.other.ConnectionWrapper;
import me.extremesnow.datalib.other.DataPair;

public abstract class AbstractSQL {
    private final String dbTable;

    public synchronized ConnectionWrapper getConnection() {
        return new ConnectionWrapper(this.provideConnection(), this::evict);
    }

    public AbstractSQL(String dbTable) {
        this.dbTable = dbTable;
    }

    public ResultSet executeQuery(String query, boolean modifies) throws SQLException {
        AtomicReference resultSet = new AtomicReference();
        this.getConnection().use(conn -> {
            Statement statement = conn.createStatement();
            if (modifies) {
                statement.execute(query);
            } else {
                resultSet.set(statement.executeQuery(query));
            }
            statement.close();
            conn.close();
        });
        if (resultSet.get() == null) {
            return null;
        }
        return (ResultSet)resultSet.get();
    }

    public synchronized List<String> getTables() {
        ArrayList<String> tables = new ArrayList<String>();
        this.getConnection().use(conn -> {
            try (ResultSet resultSet = conn.getMetaData().getTables(null, null, null, null);){
                while (resultSet.next()) {
                    tables.add(resultSet.getString(3));
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to get tables", throwable);
            }
        }).evict();
        return tables;
    }

    public synchronized boolean isPrimaryKeyUsed(String table, String[] structure, String primaryKey) {
        return this.getConnection().provideAndEvict(conn -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        this.getConnection().use(conn -> {
            try (Statement statement = conn.createStatement();
                 ResultSet rs = statement.executeQuery("SELECT * FROM " + this.dbTable);){
                ResultSetMetaData data = rs.getMetaData();
                int columnLen = data.getColumnCount();
                for (int index = 1; index <= columnLen; ++index) {
                    columns.add(data.getColumnName(index));
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to get columns of table " + this.dbTable, e);
            }
        }).evict();
        return columns;
    }

    public abstract String getType();

    protected abstract Connection provideConnection();

    public abstract void renameColumn(String var1, DataPair<String, String> ... var2);

    public abstract void dropColumn(String var1, String ... var2);

    public abstract void evict(Connection var1);

    public abstract void shutdown();

    public String getDbTable() {
        return this.dbTable;
    }
}

