/*
 * Decompiled with CFR 0.152.
 */
package me.extremesnow.datalib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.function.Consumer;
import lombok.NonNull;

public class DataManager {
    public static DataManager instance;
    private Consumer<Runnable> asyncRunner;
    private Consumer<Runnable> syncRunner = Runnable::run;
    private Consumer<Throwable> errorHandler;
    private Consumer<GsonBuilder> onBuild;
    private Gson gson;
    private static boolean debug;

    public DataManager(@NonNull Consumer<Runnable> asyncRunner, @NonNull Consumer<Runnable> syncRunner, Consumer<Throwable> errorHandler, boolean debug) {
        if (asyncRunner == null) {
            throw new NullPointerException("asyncRunner is marked non-null but is null");
        }
        if (syncRunner == null) {
            throw new NullPointerException("syncRunner is marked non-null but is null");
        }
        if (instance != null) {
            System.out.println("Already an Instance of DataLib");
            return;
        }
        instance = this;
        this.asyncRunner = asyncRunner;
        this.errorHandler = errorHandler;
        this.syncRunner = syncRunner;
        DataManager.setDebug(debug);
        DataManager.disableLoggers();
    }

    public DataManager(@NonNull Consumer<Runnable> asyncRunner, @NonNull Consumer<Runnable> syncRunner, Consumer<Throwable> errorHandler) {
        if (asyncRunner == null) {
            throw new NullPointerException("asyncRunner is marked non-null but is null");
        }
        if (syncRunner == null) {
            throw new NullPointerException("syncRunner is marked non-null but is null");
        }
        if (instance != null) {
            System.out.println("Already an Instance of DataLib");
            return;
        }
        instance = this;
        this.asyncRunner = asyncRunner;
        this.errorHandler = errorHandler;
        this.syncRunner = syncRunner;
        DataManager.disableLoggers();
    }

    public Consumer<Runnable> getRunner(boolean async) {
        return async ? this.asyncRunner : this.syncRunner;
    }

    public static void disableLoggers() {
    }

    public Gson getGson() {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.serializeNulls();
            builder.disableHtmlEscaping();
            builder.setLenient();
            if (this.onBuild != null) {
                this.onBuild.accept(builder);
            }
            this.gson = builder.create();
        }
        return this.gson;
    }

    public static DataManager getInstance() {
        return instance;
    }

    public Consumer<Throwable> getErrorHandler() {
        return this.errorHandler;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        DataManager.debug = debug;
    }

    static {
        debug = false;
    }
}

