/*
 * Decompiled with CFR 0.152.
 */
package ch.fetz.ServerManager.spigot.Utils;

import ch.fetz.ServerManager.Utils.SQLStatementParameter;
import ch.fetz.ServerManager.Utils.SQLStatementParameterType;
import ch.fetz.ServerManager.spigot.SpigotServerManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class SpigotManager {
    private final SpigotServerManager plugin;

    public SpigotManager(SpigotServerManager spigotServerManager) {
        this.plugin = spigotServerManager;
    }

    public ArrayList<String> getAllServers() {
        ArrayList<String> servers = new ArrayList<String>();
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers", new ArrayList<SQLStatementParameter>());
        try {
            while (rs.next()) {
                servers.add(rs.getString("systemname"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return servers;
    }

    public String getIp(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getString("ip");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Integer getPort(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getInt("port");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getDisplayName(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getString("displayname");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getMOTD(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getString("motd");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Boolean isLobby(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("islobby");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isActive(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("isactive");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isRestricted(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("isrestricted");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isOnline(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("isonline");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

