/*
 * Decompiled with CFR 0.152.
 */
package ch.fetz.ServerManager.spigot.Utils;

import ch.fetz.ServerManager.Utils.SQLStatementParameter;
import ch.fetz.ServerManager.spigot.SpigotServerManager;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class MySQL {
    private final SpigotServerManager plugin;
    private final HikariDataSource dataSource;

    public MySQL(SpigotServerManager spigotServerManager) {
        this.plugin = spigotServerManager;
        try {
            Class.forName("org.mariadb.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mariadb://" + this.plugin.mysqlHost + ":" + this.plugin.mysqlPort + "/" + this.plugin.mysqlDatabase);
        config.setUsername(this.plugin.mysqlUser);
        config.setPassword(this.plugin.mysqlPassword);
        config.setPoolName("BSM-Pool");
        this.dataSource = new HikariDataSource(config);
        this.createTable();
    }

    public void createTable() {
        try {
            this.update("CREATE TABLE IF NOT EXISTS servermanager_servers(id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, systemname TEXT, ip TEXT, port INT, displayname TEXT, motd TEXT, islobby BOOLEAN, isactive BOOLEAN, isrestricted BOOLEAN, isonline BOOLEAN)", new ArrayList<SQLStatementParameter>());
            this.update("CREATE TABLE IF NOT EXISTS servermanager_players(id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, uuid TEXT, name TEXT, notify BOOLEAN)", new ArrayList<SQLStatementParameter>());
        }
        catch (Exception ex) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.prefix + "\u00a7cCould not create the MySQL Table!");
        }
    }

    public void update(String qry, ArrayList<SQLStatementParameter> parameters) {
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ps = connection.prepareStatement(qry);
            for (SQLStatementParameter parameter : parameters) {
                switch (parameter.type) {
                    case STRING: {
                        ps.setString(parameter.index, (String)parameter.value);
                        break;
                    }
                    case INT: {
                        ps.setInt(parameter.index, (Integer)parameter.value);
                        break;
                    }
                    case DOUBLE: {
                        ps.setDouble(parameter.index, (Double)parameter.value);
                        break;
                    }
                    case BOOL: {
                        ps.setBoolean(parameter.index, (Boolean)parameter.value);
                        break;
                    }
                    case LONG: {
                        ps.setLong(parameter.index, (Long)parameter.value);
                    }
                }
            }
            ps.executeUpdate();
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet getResult(String qry, ArrayList<SQLStatementParameter> parameters) {
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ps = connection.prepareStatement(qry);
            for (SQLStatementParameter parameter : parameters) {
                switch (parameter.type) {
                    case STRING: {
                        ps.setString(parameter.index, (String)parameter.value);
                        break;
                    }
                    case INT: {
                        ps.setInt(parameter.index, (Integer)parameter.value);
                        break;
                    }
                    case DOUBLE: {
                        ps.setDouble(parameter.index, (Double)parameter.value);
                        break;
                    }
                    case BOOL: {
                        ps.setBoolean(parameter.index, (Boolean)parameter.value);
                        break;
                    }
                    case LONG: {
                        ps.setLong(parameter.index, (Long)parameter.value);
                    }
                }
            }
            ResultSet rs = ps.executeQuery();
            connection.close();
            return rs;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

