/*
 * Decompiled with CFR 0.152.
 */
package ch.fetz.ServerManager.Utils;

import ch.fetz.ServerManager.ServerManager;
import ch.fetz.ServerManager.Utils.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitorInputStream;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class Updater {
    private final ServerManager plugin;
    public String update = null;

    public Updater(ServerManager serverManager) {
        this.plugin = serverManager;
    }

    public void checkForUpdate() {
        this.update = this.plugin.getDescription().getVersion();
        try {
            URL url = new URL("https://fetz-gr.ch/BungeeServerManager/version.php");
            String pr = new BufferedReader(new InputStreamReader(url.openStream())).readLine();
            if (pr.equals("SQLError")) {
                ProxyServer.getInstance().getConsole().sendMessage(this.plugin.prefix + "\u00a7cThere was an error while checking for an update");
            } else {
                this.update = pr;
            }
        }
        catch (Exception e) {
            ProxyServer.getInstance().getConsole().sendMessage(this.plugin.prefix + "\u00a7cCouldn't check for an update");
        }
        Version current = new Version(this.plugin.getDescription().getVersion());
        Version testing = new Version(this.update);
        switch (current.compareTo(testing)) {
            case 1: {
                ProxyServer.getInstance().getConsole().sendMessage(this.plugin.prefix + "\u00a7aYou're on a beta version!");
                break;
            }
            case 0: {
                ProxyServer.getInstance().getConsole().sendMessage(this.plugin.prefix + "\u00a7aYou're on the latest version!");
                break;
            }
            case -1: {
                ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        ProxyServer.getInstance().broadcast(Updater.this.plugin.prefix + "\u00a7aUpdate found! New Version\u00a78: \u00a7ev" + Updater.this.update);
                        ProxyServer.getInstance().broadcast(Updater.this.plugin.prefix + "\u00a7aNew version is downloading!");
                        ProxyServer.getInstance().broadcast(Updater.this.plugin.prefix + "\u00a7cThe server will restart automaticly when the update is downloaded");
                        try {
                            Updater.this.downloadFile("https://fetz-gr.ch/BungeeServerManager/" + Updater.this.update + "/ServerManager.jar");
                        }
                        catch (Exception e) {
                            ProxyServer.getInstance().broadcast(Updater.this.plugin.prefix + "\u00a7cThe update can't be downloaded.");
                        }
                    }
                });
            }
        }
    }

    private void downloadFile(String http) throws Exception {
        int n;
        URL url = new URL(http);
        URLConnection uc = url.openConnection();
        InputStream is = uc.getInputStream();
        ProgressMonitorInputStream pmis = new ProgressMonitorInputStream(null, "Downloading...", is);
        pmis.getProgressMonitor().setMaximum(uc.getContentLength());
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ProxyServer.getInstance().broadcast(Updater.this.plugin.prefix + "\u00a7cThe server is going to restart now!");
                for (ProxiedPlayer all : ProxyServer.getInstance().getPlayers()) {
                    all.disconnect("\u00a7cRestart due to an update!");
                }
            }
        });
        FileOutputStream out = new FileOutputStream("plugins/ServerManager.jar");
        byte[] buffer = new byte[1024];
        while ((n = pmis.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        pmis.close();
        out.close();
        File jar = new File("plugins/ServerManager.jar");
        String path = jar.getAbsolutePath();
        String oldfile = path.substring(0, path.length() - 12);
        jar.renameTo(new File(oldfile + "plugins/ServerManager.jar"));
        jar.setExecutable(true);
        ProxyServer.getInstance().stop();
    }
}

