/*
 * Decompiled with CFR 0.152.
 */
package ch.fetz.ServerManager.Utils;

import ch.fetz.ServerManager.ServerManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class PluginMessageManager
implements Listener {
    private final ServerManager plugin;
    private final String spacer = "#####";

    public PluginMessageManager(ServerManager serverManager) {
        this.plugin = serverManager;
        this.plugin.getProxy().getPluginManager().registerListener((Plugin)serverManager, (Listener)this);
    }

    public void sendPluginMessage(String message, ServerInfo server) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        try {
            out.writeUTF(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        server.sendData("bsm:cmd", stream.toByteArray());
    }

    @EventHandler
    public void onReceiveMessage(PluginMessageEvent e) {
        if (!e.getTag().equals("bsm:cmd")) {
            return;
        }
        if (!(e.getSender() instanceof Server)) {
            return;
        }
        Server server = (Server)e.getSender();
        ByteArrayInputStream stream = new ByteArrayInputStream(e.getData());
        DataInputStream input = new DataInputStream(stream);
        try {
            this.processIncomingMessage(server, input.readUTF().split("#####"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processIncomingMessage(Server server, String[] message) {
        if (message[0].equals("playercount")) {
            String bungeename = message[1];
            if (this.plugin.getManager().isActive(bungeename).booleanValue()) {
                int playercount = ProxyServer.getInstance().getServerInfo(bungeename).getPlayers().size();
                this.sendPluginMessage("playercount#####" + bungeename + "#####" + playercount, server.getInfo());
            } else {
                this.sendPluginMessage("playercount#####" + bungeename + "#####0", server.getInfo());
            }
        }
    }
}

