/*
 * Decompiled with CFR 0.152.
 */
package ch.fetz.ServerManager.Utils;

import ch.fetz.ServerManager.ServerManager;
import ch.fetz.ServerManager.Utils.SQLStatementParameter;
import ch.fetz.ServerManager.Utils.SQLStatementParameterType;
import java.net.InetSocketAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class Manager {
    private final ServerManager plugin;

    public Manager(ServerManager serverManager) {
        this.plugin = serverManager;
    }

    public boolean isInDatabase(final String name) {
        boolean isInDatabase = false;
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            isInDatabase = rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isInDatabase;
    }

    public void createServer(final String name, String ip, Integer port, String motd, String displayname, Boolean isLobby, Boolean isActive, Boolean isrestricted, Boolean isonline) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT systemname FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (!rs.next()) {
                ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, ip));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.INT, 3, port));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 4, displayname));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 5, motd));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 6, isActive));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 7, isLobby));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 8, isrestricted));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 9, isonline));
                this.plugin.getMySQL().update("INSERT INTO servermanager_servers (systemname, ip, port, displayname, motd, isactive, islobby, isrestricted, isonline) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", parameters);
                if (isActive.booleanValue()) {
                    this.addServer(name);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createPlayer(final ProxiedPlayer p) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT uuid FROM servermanager_players WHERE uuid = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, p.getUniqueId().toString()));
            }
        });
        try {
            if (!rs.next()) {
                ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, p.getUniqueId().toString()));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, p.getName()));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 3, false));
                this.plugin.getMySQL().update("INSERT INTO servermanager_players (uuid, name, notify) VALUES (?, ?, ?)", parameters);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void checkPlayerName(final ProxiedPlayer p) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_players WHERE uuid = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, p.getUniqueId().toString()));
            }
        });
        try {
            while (!rs.next()) {
                if (!rs.getString("name").equals(p.getName())) continue;
                ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, p.getName()));
                parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, p.getUniqueId().toString()));
                this.plugin.getMySQL().update("UPDATE servermanager_players SET name = ? WHERE uuid = ?", parameters);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setNotificationStatus(ProxiedPlayer p, boolean notify) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 1, notify));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, p.getUniqueId().toString()));
        this.plugin.getMySQL().update("UPDATE servermanager_players SET notify = ? WHERE uuid = ?", parameters);
    }

    public Boolean getNotificationStatus(final ProxiedPlayer p) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_players WHERE uuid = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, p.getUniqueId().toString()));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("notify");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void removeServer(final String name) {
        if (this.isActive(name).booleanValue()) {
            this.removeServer(name, this.isLobby(name));
        }
        this.plugin.getMySQL().update("DELETE FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
    }

    public ArrayList<String> getAllServers() {
        ArrayList<String> servers = new ArrayList<String>();
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers", new ArrayList<SQLStatementParameter>());
        try {
            while (rs.next()) {
                servers.add(rs.getString("systemname"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return servers;
    }

    public String getIp(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getString("ip");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setPort(String name, int port) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.INT, 1, port));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET port = ? WHERE systemname = ?", parameters);
    }

    public Integer getPort(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getInt("port");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setIp(String name, String ip) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, ip));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET ip = ? WHERE systemname = ?", parameters);
    }

    public String getDisplayName(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getString("displayname");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setDisplayname(String name, String displayname) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, displayname));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET displayname = ? WHERE systemname = ?", parameters);
    }

    public String getMOTD(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getString("motd");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setMOTD(String name, String motd) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, motd));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET motd = ? WHERE systemname = ?", parameters);
    }

    public Boolean isLobby(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("islobby");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isActive(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("isactive");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isRestricted(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("isrestricted");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isOnline(final String name) {
        ResultSet rs = this.plugin.getMySQL().getResult("SELECT * FROM servermanager_servers WHERE systemname = ?", new ArrayList<SQLStatementParameter>(){
            {
                this.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 1, name));
            }
        });
        try {
            if (rs.next()) {
                return rs.getBoolean("isonline");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setIsActive(String name, Boolean isactive) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 1, isactive));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET isactive = ? WHERE systemname = ?", parameters);
    }

    public void setIsLobby(String name, Boolean lobby) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 1, lobby));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET islobby = ? WHERE systemname = ?", parameters);
    }

    public void setIsRestricted(String name, Boolean restricted) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 1, restricted));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET isrestricted = ? WHERE systemname = ?", parameters);
    }

    public void setIsOnline(String name, Boolean isonline) {
        ArrayList<SQLStatementParameter> parameters = new ArrayList<SQLStatementParameter>();
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.BOOL, 1, isonline));
        parameters.add(new SQLStatementParameter(SQLStatementParameterType.STRING, 2, name));
        this.plugin.getMySQL().update("UPDATE servermanager_servers SET isonline = ? WHERE systemname = ?", parameters);
    }

    public void addAllServers() {
        for (String name : this.getAllServers()) {
            if (!this.isActive(name).booleanValue()) continue;
            ProxyServer.getInstance().getServers().put(name, ProxyServer.getInstance().constructServerInfo(name, new InetSocketAddress(this.getIp(name), (int)this.getPort(name)), this.getMOTD(name), false));
            if (this.isLobby(name).booleanValue()) {
                this.plugin.lobbies.add(ProxyServer.getInstance().getServerInfo(name));
                continue;
            }
            this.plugin.nonlobbies.add(ProxyServer.getInstance().getServerInfo(name));
        }
    }

    public void addServer(String name) {
        ProxyServer.getInstance().getServers().put(name, ProxyServer.getInstance().constructServerInfo(name, new InetSocketAddress(this.getIp(name), (int)this.getPort(name)), this.getMOTD(name), false));
        if (this.isLobby(name).booleanValue()) {
            this.plugin.lobbies.add(ProxyServer.getInstance().getServerInfo(name));
        } else {
            this.plugin.nonlobbies.add(ProxyServer.getInstance().getServerInfo(name));
        }
    }

    public void removeServer(String name, Boolean lobby) {
        ProxyServer.getInstance().getServers().remove(name);
        if (lobby.booleanValue()) {
            this.plugin.lobbies.remove(ProxyServer.getInstance().getServerInfo(name));
        } else {
            this.plugin.nonlobbies.remove(ProxyServer.getInstance().getServerInfo(name));
        }
    }

    public void clearAllServers() {
        ProxyServer.getInstance().getServers().clear();
        this.plugin.lobbies.clear();
        this.plugin.nonlobbies.clear();
    }
}

