/*
 * Decompiled with CFR 0.152.
 */
package ch.fetz.ServerManager;

import ch.fetz.ServerManager.Commands.command_goto;
import ch.fetz.ServerManager.Commands.command_greload;
import ch.fetz.ServerManager.Commands.command_hub;
import ch.fetz.ServerManager.Commands.command_notify;
import ch.fetz.ServerManager.Commands.command_servers;
import ch.fetz.ServerManager.Commands.command_whereami;
import ch.fetz.ServerManager.Listener.JoinEvent_Listener;
import ch.fetz.ServerManager.Listener.Ping_Listener;
import ch.fetz.ServerManager.Listener.ServerConnectEvent_Listener;
import ch.fetz.ServerManager.Listener.ServerKickEvent_Listener;
import ch.fetz.ServerManager.Listener.ServerSwitch_Listener;
import ch.fetz.ServerManager.Utils.Manager;
import ch.fetz.ServerManager.Utils.Messages;
import ch.fetz.ServerManager.Utils.Metrics;
import ch.fetz.ServerManager.Utils.MySQL;
import ch.fetz.ServerManager.Utils.PluginMessageManager;
import ch.fetz.ServerManager.Utils.ServerPinger;
import ch.fetz.ServerManager.Utils.Updater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class ServerManager
extends Plugin {
    private ServerManager instance;
    private Manager manager;
    private MySQL mySQL;
    private Metrics metrics;
    private Messages messages;
    private Updater updater;
    private ServerPinger serverPinger;
    public String prefix = "\u00a7f[\u00a74ServerManager\u00a7f] ";
    public Configuration config;
    public String mysqlHost;
    public Integer mysqlPort;
    public String mysqlUser;
    public String mysqlDatabase;
    public String mysqlPassword;
    public boolean setHeader;
    public String headerText;
    public boolean setFooter;
    public String footerText;
    public String motd;
    public String hubCommands;
    public boolean enableMOTD = true;
    public boolean onemoreplayer = false;
    public boolean activateUpdater = true;
    public boolean forcedServers = false;
    public ArrayList<ServerInfo> lobbies = new ArrayList();
    public ArrayList<ServerInfo> nonlobbies = new ArrayList();
    public ArrayList<ProxiedPlayer> receiver = new ArrayList();
    private PluginMessageManager pluginMessageManager;
    private final int configVersion = 3;
    private ScheduledTask serverPingTask;
    public boolean enableOnlineCheck = true;
    private int checkDelay = 10;

    public void onEnable() {
        this.instance = this;
        this.createConfig();
        this.manager = new Manager(this);
        this.mySQL = new MySQL(this);
        this.messages = new Messages(this);
        this.updater = new Updater(this);
        this.serverPinger = new ServerPinger(this);
        this.pluginMessageManager = new PluginMessageManager(this);
        this.getProxy().registerChannel("bsm:cmd");
        this.registerCommands();
        this.registerListener();
        this.messages.loadMessages();
        try {
            if (this.activateUpdater) {
                this.updater.checkForUpdate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.manager.addAllServers();
        if (this.enableOnlineCheck) {
            this.startServerPinging();
        }
        ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.prefix + "\u00a77All servers were \u00a7asuccessfully \u00a77added"});
        this.metrics = new Metrics(this);
        ProxyServer.getInstance().getConsole().sendMessage("\u00a78-----------===== " + this.prefix + "\u00a78=====-----------");
        ProxyServer.getInstance().getConsole().sendMessage("\u00a77The plugin was \u00a7asuccessfully \u00a77activated");
        ProxyServer.getInstance().getConsole().sendMessage("\u00a77Plugin by\u00a78: \u00a7eNojo | Noah");
        ProxyServer.getInstance().getConsole().sendMessage("\u00a77Plugin Version\u00a78: \u00a7e" + this.getDescription().getVersion());
        ProxyServer.getInstance().getConsole().sendMessage("\u00a78-----------===== " + this.prefix + "\u00a78=====-----------");
    }

    public void onDisable() {
        try {
            this.serverPingTask.cancel();
            for (ServerInfo server : this.lobbies) {
                this.getManager().setIsOnline(server.getName(), false);
            }
            for (ServerInfo server : this.nonlobbies) {
                this.getManager().setIsOnline(server.getName(), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ProxyServer.getInstance().getConsole().sendMessage("\u00a78-----------===== " + this.prefix + "\u00a78=====-----------");
        ProxyServer.getInstance().getConsole().sendMessage("\u00a77The plugin was \u00a7asuccessfully \u00a77deactivated");
        ProxyServer.getInstance().getConsole().sendMessage("\u00a77Plugin by\u00a78: \u00a7eNojo | Noah");
        ProxyServer.getInstance().getConsole().sendMessage("\u00a78-----------===== " + this.prefix + "\u00a78=====-----------");
    }

    private void createConfig() {
        try {
            File file;
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
                try (InputStream in = this.getResourceAsStream("config.yml");){
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
            if (this.config.getInt("ConfigVersion") < 3) {
                File backup = new File(this.getDataFolder(), "config_BACKUP.yml");
                file.renameTo(backup);
                File file2 = new File(this.getDataFolder(), "config.yml");
                if (!file2.exists()) {
                    try (InputStream in = this.getResourceAsStream("config.yml");){
                        Files.copy(in, file2.toPath(), new CopyOption[0]);
                        this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file2);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.mysqlHost = this.config.getString("MySQL.Host");
            this.mysqlPort = this.config.getInt("MySQL.Port");
            this.mysqlUser = this.config.getString("MySQL.User");
            this.mysqlDatabase = this.config.getString("MySQL.Database");
            this.mysqlPassword = this.config.getString("MySQL.Password");
            this.setHeader = this.config.getBoolean("Header.SetHeader");
            this.headerText = this.config.getString("Header.HeaderText");
            this.setFooter = this.config.getBoolean("Footer.SetFooter");
            this.footerText = this.config.getString("Footer.FooterText");
            this.motd = this.config.getString("ServerPing.MOTDText");
            this.enableMOTD = this.config.getBoolean("ServerPing.SetMOTD");
            this.onemoreplayer = this.config.getBoolean("ServerPing.OneMorePlayer");
            this.hubCommands = this.config.getString("General.HubCommands");
            this.activateUpdater = this.config.getBoolean("General.AutoUpdater");
            this.forcedServers = this.config.getBoolean("General.ForceServers");
            this.enableOnlineCheck = this.config.getBoolean("General.EnableOnlineOfflineCheck");
            this.checkDelay = this.config.getInt("General.OnlineOfflineCheckDelay");
            this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("Language.prefix") + " "));
        }
        catch (Exception ex) {
            ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.prefix + "\u00a7cThe config could not be created! Please PM NojoLP with the following StackTrace on the Spigot-Forums!"});
            ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.prefix + "\u00a77================================\u00a78[\u00a74COPY STACK TRACE FROM HERE\u00a78]\u00a77================================"});
            ex.printStackTrace();
            ProxyServer.getInstance().getConsole().sendMessages(new String[]{this.prefix + "\u00a77================================\u00a78[\u00a74COPY STACK TRACE UP TO HERE\u00a78]\u00a77================================"});
        }
    }

    private void registerCommands() {
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new command_servers("servermanager", this));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new command_servers("sm", this));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new command_whereami("whereami", this));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new command_goto("goto", this));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new command_greload("greload", this));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new command_notify("notify", this));
        for (String command : this.hubCommands.split(";")) {
            if (command.equalsIgnoreCase("null")) continue;
            ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new command_hub(command, this));
        }
    }

    private void registerListener() {
        new JoinEvent_Listener(this);
        new ServerSwitch_Listener(this);
        new ServerConnectEvent_Listener(this);
        new Ping_Listener(this);
        new ServerKickEvent_Listener(this);
    }

    public ServerManager getInstance() {
        return this.instance;
    }

    public Manager getManager() {
        return this.manager;
    }

    public MySQL getMySQL() {
        return this.mySQL;
    }

    public Messages getMessages() {
        return this.messages;
    }

    private void startServerPinging() {
        try {
            this.serverPingTask = ProxyServer.getInstance().getScheduler().schedule((Plugin)this, () -> this.serverPinger.checkAllServers(), (long)this.checkDelay, (long)this.checkDelay, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

