/*
 * Decompiled with CFR 0.152.
 */
package ch.fetz.ServerManager.Commands;

import ch.fetz.ServerManager.ServerManager;
import com.google.common.collect.ImmutableSet;
import java.security.SecureRandom;
import java.util.HashSet;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;

public class command_servers
extends Command
implements TabExecutor {
    private final ServerManager plugin;

    public command_servers(String servermanager, ServerManager serverManager) {
        super(servermanager);
        this.plugin = serverManager;
    }

    public void execute(CommandSender sender, String[] args) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> {
            if (sender instanceof ProxiedPlayer) {
                ProxiedPlayer p = (ProxiedPlayer)sender;
                if (args.length == 0) {
                    if (p.hasPermission("servermanager.help")) {
                        this.sendAvailableCommands(p);
                    } else {
                        p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                    }
                    return;
                }
                if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("list")) {
                        if (p.hasPermission("servermanager.servers.list")) {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVERS_LIST_HEADER);
                            int i = 1;
                            for (String name : this.plugin.getManager().getAllServers()) {
                                p.sendMessage(this.plugin.getMessages().SERVER_LIST_INFO.replace("%POSITION%", String.valueOf(i)).replace("%NAME%", name).replace("%ISONLINE%", this.onlineOfflineString(this.plugin.getManager().isOnline(name))).replace("%ISENABLED%", this.trueFalseString(this.plugin.getManager().isActive(name))).replace("%ISLOBBY%", this.trueFalseString(this.plugin.getManager().isLobby(name))).replace("%DISPLAYNAME%", this.plugin.getManager().getDisplayName(name)).replace("%ISRESTRICTED%", this.trueFalseString(this.plugin.getManager().isRestricted(name))).replace("%IP%", this.plugin.getManager().getIp(name)).replace("%PORT%", String.valueOf(this.plugin.getManager().getPort(name))));
                                p.sendMessage(" ");
                                ++i;
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("reload")) {
                        if (p.hasPermission("servermanager.servers.reload")) {
                            p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                            this.plugin.getManager().clearAllServers();
                            this.plugin.getManager().addAllServers();
                            p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                            this.sendMessage(this.plugin.prefix + this.plugin.getMessages().ALL_SERVER_RELOAD_BROADCAST.replace("%PLAYER%", p.getName()));
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else {
                        this.sendAvailableCommands(p);
                    }
                    return;
                }
                if (args.length == 2) {
                    if (args[0].equalsIgnoreCase("delete")) {
                        if (p.hasPermission("servermanager.servers.delete")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                if (this.plugin.getManager().isActive(name).booleanValue()) {
                                    for (ProxiedPlayer all : ProxyServer.getInstance().getServerInfo(name).getPlayers()) {
                                        all.connect(this.plugin.lobbies.get(new SecureRandom().nextInt(this.plugin.lobbies.size())));
                                        all.sendMessage(this.plugin.prefix + this.plugin.getMessages().PREVIOUS_SERVER_DELETED_INFO);
                                    }
                                }
                                p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                this.plugin.getManager().removeServer(name);
                                p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                this.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_DELETED_BROADCAST.replace("%SERVER%", this.plugin.getManager().getDisplayName(name)).replace("%PLAYER%", p.getName()));
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("reload")) {
                        if (p.hasPermission("servermanager.servers.reload")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                                this.plugin.getManager().addServer(name);
                                p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                this.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_RELOADED_BROADCAST.replace("%DISPLAYNAME%", this.plugin.getManager().getDisplayName(name)).replace("%PLAYER%", p.getName()));
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("enable")) {
                        if (p.hasPermission("servermanager.servers.enable")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                if (!this.plugin.getManager().isActive(name).booleanValue()) {
                                    p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                    this.plugin.getManager().setIsActive(name, true);
                                    this.plugin.getManager().addServer(name);
                                    p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                    this.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_ENABLED_BROADCAST.replace("%DISPLAYNAME%", this.plugin.getManager().getDisplayName(name)).replace("%PLAYER%", p.getName()));
                                } else {
                                    p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_ALREADY_ENABLED);
                                }
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("disable")) {
                        if (p.hasPermission("servermanager.servers.disable")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                if (this.plugin.getManager().isActive(name).booleanValue()) {
                                    p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                    this.plugin.getManager().setIsActive(name, false);
                                    for (ProxiedPlayer all : ProxyServer.getInstance().getServerInfo(name).getPlayers()) {
                                        all.connect(this.plugin.lobbies.get(new SecureRandom().nextInt(this.plugin.lobbies.size())));
                                        all.sendMessage(this.plugin.prefix + this.plugin.getMessages().PREVIOUS_SERVER_DISABLED);
                                    }
                                    this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                                    p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                    this.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_DISABLED_BROADCAST.replace("%DISPLAYNAME%", this.plugin.getManager().getDisplayName(name)).replace("%PLAYER%", p.getName()));
                                } else {
                                    p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_ALREADY_DISABLED);
                                }
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("info")) {
                        if (p.hasPermission("servermanager.servers.info")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                p.sendMessage(this.plugin.prefix + "\u00a77Info about\u00a78: " + this.plugin.getManager().getDisplayName(name));
                                p.sendMessage("\u00a77Systemname\u00a78:\u00a7a " + name);
                                p.sendMessage(" ");
                                p.sendMessage("\u00a77Status\u00a78: " + this.onlineOfflineString(this.plugin.getManager().isOnline(name)));
                                p.sendMessage(" ");
                                p.sendMessage("\u00a77Displayname\u00a78: " + this.plugin.getManager().getDisplayName(name));
                                p.sendMessage(" ");
                                p.sendMessage("\u00a77Enabled\u00a78: " + this.trueFalseString(this.plugin.getManager().isActive(name)));
                                p.sendMessage(" ");
                                p.sendMessage("\u00a77Lobby\u00a78: " + this.trueFalseString(this.plugin.getManager().isActive(name)));
                                p.sendMessage(" ");
                                p.sendMessage("\u00a77Restricted\u00a78: " + this.trueFalseString(this.plugin.getManager().isActive(name)));
                                p.sendMessage(" ");
                                p.sendMessage("\u00a77IP\u00a78:\u00a7a " + this.plugin.getManager().getIp(name));
                                p.sendMessage(" ");
                                p.sendMessage("\u00a77Port\u00a78:\u00a7a " + this.plugin.getManager().getPort(name));
                                p.sendMessage(" ");
                                Object players = null;
                                if (this.plugin.getManager().isActive(name).booleanValue() && ProxyServer.getInstance().getServerInfo(name) != null) {
                                    ServerInfo serverInfo = ProxyServer.getInstance().getServerInfo(name);
                                    for (ProxiedPlayer all : serverInfo.getPlayers()) {
                                        if (players == null) {
                                            players = "\u00a7a" + all.getName();
                                            continue;
                                        }
                                        players = (String)players + "\u00a77, " + all.getName();
                                    }
                                } else {
                                    players = "\u00a7cOffline";
                                }
                                p.sendMessage("\u00a77Players\u00a78: " + (String)players);
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("kick")) {
                        if (p.hasPermission("servermanager.servers.kick")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                if (this.plugin.getManager().isActive(name).booleanValue() && ProxyServer.getInstance().getServerInfo(name) != null) {
                                    p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                    for (ProxiedPlayer all : ProxyServer.getInstance().getServerInfo(name).getPlayers()) {
                                        if (all.hasPermission("servermanager.ignorekick")) continue;
                                        all.connect(this.plugin.lobbies.get(new SecureRandom().nextInt(this.plugin.lobbies.size())));
                                        all.sendMessage(this.plugin.prefix + this.plugin.getMessages().PREVIOUS_SERVER_EMPTIED);
                                    }
                                    p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                    this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been emptied by \u00a74" + p.getName());
                                } else {
                                    p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_ACTIVE);
                                }
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else {
                        this.sendAvailableCommands(p);
                    }
                    return;
                }
                if (args.length == 3) {
                    if (args[0].equalsIgnoreCase("setlobby")) {
                        if (p.hasPermission("servermanager.servers.setlobby")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                Boolean isLobby;
                                try {
                                    isLobby = Boolean.parseBoolean(args[2]);
                                }
                                catch (Exception ex) {
                                    p.sendMessage(this.plugin.prefix + "\u00a77isLobby has to be \u00a7atrue \u00a77or \u00a7cfalse");
                                    return;
                                }
                                if (isLobby.booleanValue()) {
                                    if (!this.plugin.getManager().isLobby(name).booleanValue()) {
                                        p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                        this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                                        this.plugin.getManager().setIsLobby(name, true);
                                        this.plugin.getManager().addServer(name);
                                        p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                        this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been flagged as a lobby by \u00a74" + p.getName());
                                    } else {
                                        p.sendMessage(this.plugin.prefix + "\u00a77This server is already a lobby");
                                    }
                                } else if (this.plugin.getManager().isLobby(name).booleanValue()) {
                                    p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                    this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                                    this.plugin.getManager().setIsLobby(name, false);
                                    this.plugin.getManager().addServer(name);
                                    p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                    this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been unflagged as a lobby by \u00a74" + p.getName());
                                } else {
                                    p.sendMessage(this.plugin.prefix + "\u00a77This server is not a lobby");
                                }
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("setrestricted")) {
                        if (p.hasPermission("servermanager.servers.setrestricted")) {
                            String name = args[1];
                            if (this.plugin.getManager().isInDatabase(name)) {
                                Boolean isrestricted;
                                try {
                                    isrestricted = Boolean.parseBoolean(args[2]);
                                }
                                catch (Exception ex) {
                                    p.sendMessage(this.plugin.prefix + "\u00a77isrestricted has to be \u00a7atrue \u00a77or \u00a7cfalse");
                                    return;
                                }
                                if (isrestricted.booleanValue()) {
                                    if (!this.plugin.getManager().isRestricted(name).booleanValue()) {
                                        p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                        this.plugin.getManager().setIsRestricted(name, true);
                                        p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                        this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been restricted by \u00a74BungeeConsole");
                                    } else {
                                        p.sendMessage(this.plugin.prefix + "\u00a77This server is already restricted");
                                    }
                                } else if (this.plugin.getManager().isRestricted(name).booleanValue()) {
                                    p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                    this.plugin.getManager().setIsRestricted(name, false);
                                    p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                    this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been unrestricted by \u00a74BungeeConsole");
                                } else {
                                    p.sendMessage(this.plugin.prefix + "\u00a77This server is not restricted");
                                }
                            } else {
                                p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else {
                        this.sendAvailableCommands(p);
                    }
                    return;
                }
                if (args.length >= 6) {
                    if (args[0].equalsIgnoreCase("add")) {
                        if (p.hasPermission("servermanager.servers.add")) {
                            Boolean isRestricted;
                            Boolean isEnabled;
                            Boolean isLobby;
                            Integer port;
                            String name = args[1];
                            String ip = args[2];
                            try {
                                port = Integer.parseInt(args[3]);
                            }
                            catch (Exception ex) {
                                p.sendMessage(this.plugin.prefix + "\u00a77The port has to be a number");
                                return;
                            }
                            try {
                                isLobby = Boolean.parseBoolean(args[4]);
                            }
                            catch (Exception ex) {
                                p.sendMessage(this.plugin.prefix + "\u00a77isLobby has to be \u00a7atrue \u00a77or \u00a7cfalse");
                                return;
                            }
                            try {
                                isEnabled = Boolean.parseBoolean(args[5]);
                            }
                            catch (Exception ex) {
                                p.sendMessage(this.plugin.prefix + "\u00a77isActive has to be \u00a7atrue \u00a77or \u00a7cfalse");
                                return;
                            }
                            try {
                                isRestricted = Boolean.parseBoolean(args[6]);
                            }
                            catch (Exception ex) {
                                p.sendMessage(this.plugin.prefix + "\u00a77isRestricted has to be \u00a7atrue \u00a77or \u00a7cfalse");
                                return;
                            }
                            Object displayname = "";
                            for (int i = 7; i < args.length; ++i) {
                                displayname = (String)displayname + " " + args[i];
                                displayname = ChatColor.translateAlternateColorCodes((char)'&', (String)displayname);
                            }
                            if (!this.plugin.getManager().isInDatabase(name)) {
                                p.sendMessage(this.plugin.prefix + "\u00a7aExecuting...");
                                this.plugin.getManager().createServer(name, ip, port, this.plugin.motd, (String)displayname, isLobby, isEnabled, isRestricted, false);
                                p.sendMessage(this.plugin.prefix + "\u00a7aDone");
                                this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been added by \u00a74" + p.getName());
                            } else {
                                p.sendMessage(this.plugin.prefix + "\u00a77This server is already in the database");
                            }
                        } else {
                            p.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else {
                        this.sendAvailableCommands(p);
                    }
                    return;
                }
                this.sendAvailableCommands(p);
            } else {
                if (args.length == 0) {
                    this.sendAvailableConsoleCommands(sender);
                    return;
                }
                if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("list")) {
                        sender.sendMessage(this.plugin.prefix + "\u00a77The following servers are registered in the system\u00a78:");
                        int i = 1;
                        for (String name : this.plugin.getManager().getAllServers()) {
                            sender.sendMessage(this.plugin.getMessages().SERVER_LIST_INFO.replace("%POSITION%", String.valueOf(i)).replace("%NAME%", name).replace("%ISONLINE%", this.onlineOfflineString(this.plugin.getManager().isOnline(name))).replace("%ISENABLED%", this.trueFalseString(this.plugin.getManager().isActive(name))).replace("%ISLOBBY%", this.trueFalseString(this.plugin.getManager().isLobby(name))).replace("%DISPLAYNAME%", this.plugin.getManager().getDisplayName(name)).replace("%ISRESTRICTED%", this.trueFalseString(this.plugin.getManager().isRestricted(name))).replace("%IP%", this.plugin.getManager().getIp(name)).replace("%PORT%", String.valueOf(this.plugin.getManager().getPort(name))));
                            sender.sendMessage(" ");
                            ++i;
                        }
                    } else if (args[0].equalsIgnoreCase("reload")) {
                        this.plugin.getManager().clearAllServers();
                        this.plugin.getManager().addAllServers();
                        this.sendMessage(this.plugin.prefix + this.plugin.getMessages().ALL_SERVER_RELOAD_BROADCAST.replace("%PLAYER%", "\u00a74BungeeConsole"));
                    } else {
                        this.sendAvailableConsoleCommands(sender);
                    }
                    return;
                }
                if (args.length == 2) {
                    if (args[0].equalsIgnoreCase("delete")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            if (this.plugin.getManager().isActive(name).booleanValue()) {
                                for (ProxiedPlayer all : ProxyServer.getInstance().getServerInfo(name).getPlayers()) {
                                    all.connect(this.plugin.lobbies.get(new SecureRandom().nextInt(this.plugin.lobbies.size())));
                                    all.sendMessage(this.plugin.prefix + "\u00a77The server you were previously on has been deleted! You have been connected to a lobby");
                                }
                            }
                            this.plugin.getManager().removeServer(name);
                            this.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_DELETED_BROADCAST.replace("%SERVER%", this.plugin.getManager().getDisplayName(name)).replace("%PLAYER%", "\u00a74BungeeConsole"));
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                        }
                    } else if (args[0].equalsIgnoreCase("reload")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                            this.plugin.getManager().addServer(name);
                            this.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_RELOADED_BROADCAST.replace("%DISPLAYNAME%", this.plugin.getManager().getDisplayName(name)).replace("%PLAYER%", "\u00a74BungeeConsole"));
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                        }
                    } else if (args[0].equalsIgnoreCase("enable")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            if (!this.plugin.getManager().isActive(name).booleanValue()) {
                                this.plugin.getManager().setIsActive(name, true);
                                this.plugin.getManager().addServer(name);
                                this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been enabled by \u00a74BungeeConsole");
                            } else {
                                sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_ALREADY_ENABLED);
                            }
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                        }
                    } else if (args[0].equalsIgnoreCase("disable")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            if (this.plugin.getManager().isActive(name).booleanValue()) {
                                this.plugin.getManager().setIsActive(name, false);
                                for (ProxiedPlayer all : ProxyServer.getInstance().getServerInfo(name).getPlayers()) {
                                    all.connect(this.plugin.lobbies.get(new SecureRandom().nextInt(this.plugin.lobbies.size())));
                                    all.sendMessage(this.plugin.prefix + "\u00a77The server you were previously on has been disabled! You have been connected to a lobby");
                                }
                                this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                                this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been disabled by \u00a74BungeeConsole");
                            } else {
                                sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_ALREADY_DISABLED);
                            }
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                        }
                    } else if (args[0].equalsIgnoreCase("info")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            sender.sendMessage(this.plugin.prefix + "\u00a77Info about\u00a78: " + this.plugin.getManager().getDisplayName(name));
                            sender.sendMessage("\u00a77Systemname\u00a78:\u00a7a " + name);
                            sender.sendMessage(" ");
                            sender.sendMessage("\u00a77Status\u00a78: " + this.onlineOfflineString(this.plugin.getManager().isOnline(name)));
                            sender.sendMessage(" ");
                            sender.sendMessage("\u00a77Displayname\u00a78: " + this.plugin.getManager().getDisplayName(name));
                            sender.sendMessage(" ");
                            sender.sendMessage("\u00a77Enabled\u00a78: " + this.trueFalseString(this.plugin.getManager().isActive(name)));
                            sender.sendMessage(" ");
                            sender.sendMessage("\u00a77Lobby\u00a78: " + this.trueFalseString(this.plugin.getManager().isActive(name)));
                            sender.sendMessage(" ");
                            sender.sendMessage("\u00a77Restricted\u00a78: " + this.trueFalseString(this.plugin.getManager().isRestricted(name)));
                            sender.sendMessage(" ");
                            sender.sendMessage("\u00a77IP\u00a78:\u00a7a " + this.plugin.getManager().getIp(name));
                            sender.sendMessage(" ");
                            sender.sendMessage("\u00a77Port\u00a78:\u00a7a " + this.plugin.getManager().getPort(name));
                            sender.sendMessage(" ");
                            Object players = null;
                            if (this.plugin.getManager().isActive(name).booleanValue() && ProxyServer.getInstance().getServerInfo(name) != null) {
                                ServerInfo serverInfo = ProxyServer.getInstance().getServerInfo(name);
                                for (ProxiedPlayer all : serverInfo.getPlayers()) {
                                    if (players == null) {
                                        players = "\u00a7a" + all.getName();
                                        continue;
                                    }
                                    players = (String)players + "\u00a77, " + all.getName();
                                }
                            } else {
                                players = "\u00a7cOffline";
                            }
                            sender.sendMessage("\u00a77Players\u00a78: " + (String)players);
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                        }
                    } else if (args[0].equalsIgnoreCase("kick")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            if (this.plugin.getManager().isActive(name).booleanValue() && ProxyServer.getInstance().getServerInfo(name) != null) {
                                for (ProxiedPlayer all : ProxyServer.getInstance().getServerInfo(name).getPlayers()) {
                                    if (all.hasPermission("servermanager.ignorekick")) continue;
                                    all.connect(this.plugin.lobbies.get(new SecureRandom().nextInt(this.plugin.lobbies.size())));
                                    all.sendMessage(this.plugin.prefix + "\u00a77The server you were previously on has been emptied by a staff member");
                                }
                                this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been emptied by \u00a74BungeeConsole");
                            } else {
                                sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_ACTIVE);
                            }
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().SERVER_NOT_FOUND);
                        }
                    } else {
                        this.sendAvailableConsoleCommands(sender);
                    }
                    return;
                }
                if (args.length == 3) {
                    if (args[0].equalsIgnoreCase("setlobby")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            Boolean isLobby;
                            try {
                                isLobby = Boolean.parseBoolean(args[2]);
                            }
                            catch (Exception ex) {
                                sender.sendMessage(this.plugin.prefix + "\u00a77isLobby has to be \u00a7atrue \u00a77or \u00a7cfalse");
                                return;
                            }
                            if (isLobby.booleanValue()) {
                                if (!this.plugin.getManager().isLobby(name).booleanValue()) {
                                    this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                                    this.plugin.getManager().setIsLobby(name, true);
                                    this.plugin.getManager().addServer(name);
                                    this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been flagged as a lobby by \u00a74BungeeConsole");
                                } else {
                                    sender.sendMessage(this.plugin.prefix + "\u00a77This server is already a lobby");
                                }
                            } else if (this.plugin.getManager().isLobby(name).booleanValue()) {
                                this.plugin.getManager().removeServer(name, this.plugin.getManager().isLobby(name));
                                this.plugin.getManager().setIsLobby(name, false);
                                this.plugin.getManager().addServer(name);
                                this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been unflagged as a lobby by \u00a74BungeeConsole");
                            } else {
                                sender.sendMessage(this.plugin.prefix + "\u00a77This server is not a lobby");
                            }
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else if (args[0].equalsIgnoreCase("setrestricted")) {
                        String name = args[1];
                        if (this.plugin.getManager().isInDatabase(name)) {
                            Boolean isrestricted;
                            try {
                                isrestricted = Boolean.parseBoolean(args[2]);
                            }
                            catch (Exception ex) {
                                sender.sendMessage(this.plugin.prefix + "\u00a77isrestricted has to be \u00a7atrue \u00a77or \u00a7cfalse");
                                return;
                            }
                            if (isrestricted.booleanValue()) {
                                if (!this.plugin.getManager().isRestricted(name).booleanValue()) {
                                    this.plugin.getManager().setIsRestricted(name, true);
                                    this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been restricted by \u00a74BungeeConsole");
                                } else {
                                    sender.sendMessage(this.plugin.prefix + "\u00a77This server is already restricted");
                                }
                            } else if (this.plugin.getManager().isRestricted(name).booleanValue()) {
                                this.plugin.getManager().setIsRestricted(name, false);
                                this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been unrestricted by \u00a74BungeeConsole");
                            } else {
                                sender.sendMessage(this.plugin.prefix + "\u00a77This server is not restricted");
                            }
                        } else {
                            sender.sendMessage(this.plugin.prefix + this.plugin.getMessages().NO_PERMISSION);
                        }
                    } else {
                        this.sendAvailableConsoleCommands(sender);
                    }
                    return;
                }
                if (args.length >= 6) {
                    if (args[0].equalsIgnoreCase("add")) {
                        Boolean isRestricted;
                        Boolean isEnabled;
                        Boolean isLobby;
                        Integer port;
                        String name = args[1];
                        String ip = args[2];
                        try {
                            port = Integer.parseInt(args[3]);
                        }
                        catch (Exception ex) {
                            sender.sendMessage(this.plugin.prefix + "\u00a77The port has to be a number");
                            return;
                        }
                        try {
                            isLobby = Boolean.parseBoolean(args[4]);
                        }
                        catch (Exception ex) {
                            sender.sendMessage(this.plugin.prefix + "\u00a77isLobby has to be \u00a7atrue \u00a77or \u00a7cfalse");
                            return;
                        }
                        try {
                            isEnabled = Boolean.parseBoolean(args[5]);
                        }
                        catch (Exception ex) {
                            sender.sendMessage(this.plugin.prefix + "\u00a77isActive has to be \u00a7atrue \u00a77or \u00a7cfalse");
                            return;
                        }
                        try {
                            isRestricted = Boolean.parseBoolean(args[6]);
                        }
                        catch (Exception ex) {
                            sender.sendMessage(this.plugin.prefix + "\u00a77isRestricted has to be \u00a7atrue \u00a77or \u00a7cfalse");
                            return;
                        }
                        Object displayname = "";
                        for (int i = 7; i < args.length; ++i) {
                            displayname = (String)displayname + " " + args[i];
                            displayname = ChatColor.translateAlternateColorCodes((char)'&', (String)displayname);
                        }
                        if (!this.plugin.getManager().isInDatabase(name)) {
                            this.plugin.getManager().createServer(name, ip, port, this.plugin.prefix, (String)displayname, isLobby, isEnabled, isRestricted, false);
                            this.sendMessage(this.plugin.prefix + "\u00a77The server " + this.plugin.getManager().getDisplayName(name) + " \u00a77has been added by \u00a74BungeeConsole");
                        } else {
                            sender.sendMessage(this.plugin.prefix + "\u00a77This server is already in the database");
                        }
                    } else {
                        this.sendAvailableConsoleCommands(sender);
                    }
                    return;
                }
                this.sendAvailableConsoleCommands(sender);
            }
        });
    }

    private void sendAvailableCommands(ProxiedPlayer p) {
        if (p.hasPermission("servermanager.help")) {
            p.sendMessage(this.plugin.prefix + "\u00a77The following commands are available to you\u00a78: \u00a7e[optional] <needed>");
            p.sendMessage("\u00a7e/servermanager \u00a78- \u00a77Shows this help site");
            p.sendMessage("\u00a7e/servermanager add <servername> <ip> <port> <islobby> <isactive> <isrestricted> <displayname> \u00a78- \u00a77Adds a server to your network");
            p.sendMessage("\u00a7e/servermanager delete <servername> \u00a78- \u00a77Deletes a server from your network");
            p.sendMessage("\u00a7e/servermanager reload [servername] \u00a78- \u00a77Reloads the data of a specific server or all servers in the network");
            p.sendMessage("\u00a7e/servermanager list \u00a78- \u00a77Lists all servers in your network");
            p.sendMessage("\u00a7e/servermanager info <servername> \u00a78- \u00a77Shows some information about a specific server");
            p.sendMessage("\u00a7e/servermanager enable <servername> \u00a78- \u00a77Enables a server, so players are able to connect to it");
            p.sendMessage("\u00a7e/servermanager disable <servername> \u00a78- \u00a77Disables a server, so players can't connect to it");
            p.sendMessage("\u00a7e/servermanager setlobby <name> <isLobby> \u00a78- \u00a77You can add a server to the lobby group or remove is");
            p.sendMessage("\u00a7e/servermanager setrestricted <name> <isrestricted> \u00a78- \u00a77You can restrict a server so only people with the permission servermanager.server.<servername> can join on it");
            p.sendMessage("\u00a7e/servermanager kick <servername> \u00a78- \u00a77Kicks all players from the specific server to a random lobby");
        } else {
            p.sendMessage(this.plugin.prefix + "\u00a7cYou don't have permission to execute this command");
        }
    }

    private void sendAvailableConsoleCommands(CommandSender sender) {
        sender.sendMessage(this.plugin.prefix + "\u00a77The following commands are available to you\u00a78: \u00a7e[optional] <needed>");
        sender.sendMessage("\u00a7e/servermanager \u00a78- \u00a77Shows this help site");
        sender.sendMessage("\u00a7e/servermanager add <servername> <ip> <port> <islobby> <isactive> <isrestricted> <displayname> \u00a78- \u00a77Adds a server to your network");
        sender.sendMessage("\u00a7e/servermanager delete <servername> \u00a78- \u00a77Deletes a server from your network");
        sender.sendMessage("\u00a7e/servermanager reload [servername] \u00a78- \u00a77Reloads the data of a specific server or all servers in the network");
        sender.sendMessage("\u00a7e/servermanager list \u00a78- \u00a77Lists all servers in your network");
        sender.sendMessage("\u00a7e/servermanager info <servername> \u00a78- \u00a77Shows some information about a specific server");
        sender.sendMessage("\u00a7e/servermanager enable <servername> \u00a78- \u00a77Enables a server, so players are able to connect to it");
        sender.sendMessage("\u00a7e/servermanager disable <servername> \u00a78- \u00a77Disables a server, so players can't connect to it");
        sender.sendMessage("\u00a7e/servermanager setlobby <name> <isLobby> \u00a78- \u00a77You can add a server to the lobby group or remove is");
        sender.sendMessage("\u00a7e/servermanager setrestricted <name> <isrestricted> \u00a78- \u00a77You can restrict a server so only people with the permission servermanager.server.<servername> can join on it");
        sender.sendMessage("\u00a7e/servermanager kick <servername> \u00a78- \u00a77Kicks all players from the specific server to a random lobby");
    }

    private String trueFalseString(Boolean bool) {
        if (bool.booleanValue()) {
            return "\u00a7aTrue";
        }
        return "\u00a7cFalse";
    }

    private String onlineOfflineString(Boolean bool) {
        if (bool.booleanValue()) {
            return "\u00a7aOnline";
        }
        return "\u00a7cOffline";
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length > 3 || args.length == 0) {
            return ImmutableSet.of();
        }
        HashSet<String> matches = new HashSet<String>();
        if (args.length == 2) {
            String search = args[0].toLowerCase();
            for (String server : ProxyServer.getInstance().getServers().keySet()) {
                if (!server.toLowerCase().startsWith(search)) continue;
                matches.add(server);
            }
        }
        return matches;
    }

    private void sendMessage(String message) {
        ProxyServer.getInstance().getConsole().sendMessage(message);
        for (ProxiedPlayer all : this.plugin.receiver) {
            all.sendMessage(message);
        }
    }
}

