/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.trigger;

import de.syranda.spidermysql.customclasses.ConnectionManager;
import de.syranda.spidermysql.customclasses.trigger.Trigger;
import de.syranda.spidermysql.customclasses.trigger.TriggerEvent;
import de.syranda.spidermysql.customclasses.trigger.TriggerTime;

public class TriggerBuilder {
    private String name;
    private String table;
    private TriggerTime triggerTime;
    private TriggerEvent triggerEvent;
    private String forEachRow;

    public TriggerBuilder(String name, String table, TriggerTime triggerTime, TriggerEvent triggerEvent) {
        this.name = name;
        this.table = table;
        this.triggerTime = triggerTime;
        this.triggerEvent = triggerEvent;
        this.forEachRow = "";
    }

    public TriggerBuilder(String name) {
        this.name = name;
        this.forEachRow = "";
    }

    public TriggerBuilder addStatement(String statement) {
        this.forEachRow = String.valueOf(this.forEachRow) + statement + ";";
        return this;
    }

    public TriggerBuilder setTriggerTime(TriggerTime triggerTime) {
        this.triggerTime = triggerTime;
        return this;
    }

    public TriggerBuilder setTriggerEvent(TriggerEvent triggerEvent) {
        this.triggerEvent = triggerEvent;
        return this;
    }

    public TriggerBuilder setTable(String table) {
        this.table = table;
        return this;
    }

    public void build() {
        new Trigger(this.name).delete();
        String query = "CREATE TRIGGER `" + this.name + "` " + this.triggerTime.getSyntax() + " " + this.triggerEvent.getSyntax() + " ON `" + this.table + "` FOR EACH ROW BEGIN " + this.forEachRow + " END;";
        ConnectionManager.insertStatement(query, false);
    }
}

