/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.table;

import de.syranda.spidermysql.customclasses.ConnectionManager;
import de.syranda.spidermysql.customclasses.ConventionFormatter;
import de.syranda.spidermysql.customclasses.builder.ColumnType;
import de.syranda.spidermysql.customclasses.builder.Exclude;
import de.syranda.spidermysql.customclasses.builder.ExcludeField;
import de.syranda.spidermysql.customclasses.builder.MySQLClass;
import de.syranda.spidermysql.customclasses.table.ClassSerializer;
import de.syranda.spidermysql.utils.Serializer;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class RecordResult {
    private ResultSet rs;
    private HashMap<String, Object[]> results = new HashMap();
    private HashMap<Class<?>, Object[]> resultsClasses = new HashMap();
    private int size = 0;
    private int index = -1;

    public RecordResult(ResultSet rs) {
        this.rs = rs;
        try {
            rs.beforeFirst();
            while (rs.next()) {
                ++this.size;
            }
            rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Object[] getObject(String col) {
        Object[] res = this.results.get(col);
        if (res == null) {
            res = new Object[this.getSize()];
            try {
                this.rs.beforeFirst();
                int index = 0;
                while (this.rs.next()) {
                    res[index] = this.rs.getObject(col).toString().equalsIgnoreCase("null") ? null : this.rs.getObject(col);
                    ++index;
                }
                this.rs.beforeFirst();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.results.put(col, res);
        }
        return res;
    }

    public Object getFirstObject(String col) {
        return this.getObject(col)[0];
    }

    public boolean[] getBoolean(String col) {
        boolean[] res = new boolean[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            res[i] = Integer.parseInt(this.getObject(col)[i].toString()) != 0;
            ++i;
        }
        return res;
    }

    public boolean getFirstBoolean(String col) {
        return this.getBoolean(col)[0];
    }

    public String[] getString(String col) {
        String[] res = new String[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            res[i] = col.matches("[^>]+>[^>]+") ? this.getJSONObject(col.split(">")[0])[i].get(col.split(">", 2)[1]).toString() : (this.getObject(col)[i] != null ? this.getObject(col)[i].toString() : null);
            ++i;
        }
        return res;
    }

    public String getFirstString(String col) {
        return this.getString(col)[0];
    }

    public int[] getInt(String col) {
        int[] res = new int[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            res[i] = col.matches("[^>]+>[^>]+") ? Integer.parseInt(this.getJSONObject(col.split(">")[0])[i].get(col.split(">", 2)[1]).toString()) : Integer.parseInt(this.getObject(col)[i].toString());
            ++i;
        }
        return res;
    }

    public int getFirstInt(String col) {
        return this.getInt(col)[0];
    }

    public double[] getDouble(String col) {
        double[] res = new double[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            res[i] = col.matches("[^>]+>[^>]+") ? Double.parseDouble(this.getJSONObject(col.split(">")[0])[i].get(col.split(">", 2)[1]).toString()) : Double.parseDouble(this.getObject(col)[i].toString());
            ++i;
        }
        return res;
    }

    public double getFirstDouble(String col) {
        return this.getDouble(col)[0];
    }

    public long[] getLong(String col) {
        long[] res = new long[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            res[i] = col.matches("[^>]+>[^>]+") ? Long.parseLong(this.getJSONObject(col.split(">")[0])[i].get(col.split(">", 2)[1]).toString()) : Long.parseLong(this.getObject(col)[i].toString());
            ++i;
        }
        return res;
    }

    public long getFirstLong(String col) {
        return this.getLong(col)[0];
    }

    public Object[] getBlob(String col) {
        Object[] res = new Object[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            try {
                res[i] = col.matches("[^>]+>[^>]+") ? Serializer.deserialize(this.getJSONObject(col.split(">")[0])[i].get(col.split(">", 2)[1]).toString()) : Serializer.deserialize(this.getObject(col)[i].toString());
            }
            catch (Exception e) {
                ConnectionManager.handleException(e, false);
            }
            ++i;
        }
        return res;
    }

    public Object getFirstBlob(String col) {
        return this.getBlob(col)[0];
    }

    public JSONObject[] getJSONObject(String col) {
        JSONObject[] res = new JSONObject[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            try {
                res[i] = (JSONObject)new JSONParser().parse(this.getObject(col)[i].toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return res;
    }

    public JSONObject getFirstJSONObject(String col) {
        return this.getJSONObject(col)[0];
    }

    public ResultSet getAll() {
        return this.rs;
    }

    public int getSize() {
        return this.size;
    }

    public Object[] getObjectFromType(Class<?> clazz) {
        if (this.resultsClasses.containsKey(clazz)) {
            return this.resultsClasses.get(clazz);
        }
        Object[] ret = new Object[this.getSize()];
        if (!clazz.isAnnotationPresent(MySQLClass.class)) {
            return ret;
        }
        boolean adjust = clazz.getAnnotation(MySQLClass.class).adjustFields();
        int i = 0;
        while (i < ret.length) {
            try {
                Constructor<?> consttructor = clazz.getDeclaredConstructor(new Class[0]);
                consttructor.setAccessible(true);
                ret[i] = consttructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!field.isAnnotationPresent(Exclude.class) && !Modifier.isStatic(field.getModifiers())) {
                    String fieldName;
                    String string = fieldName = adjust ? ConventionFormatter.getMySQLName(field.getName()) : field.getName();
                    if (ClassSerializer.hasSerializer(field.getType())) {
                        ClassSerializer<?> serializer = ClassSerializer.getSerializer(field.getType());
                        HashMap<String, Object> deserialize = new HashMap<String, Object>();
                        HashMap<String, Class<?>> pattern = serializer.getPattern(fieldName);
                        if (field.isAnnotationPresent(ExcludeField.class)) {
                            String[] stringArray = field.getAnnotation(ExcludeField.class).fields();
                            int n3 = stringArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String exField = stringArray[n4];
                                pattern.remove(exField);
                                ++n4;
                            }
                        }
                        for (Map.Entry<String, Class<?>> entry : pattern.entrySet()) {
                            deserialize.put(entry.getKey(), this.getObject(entry.getKey())[i]);
                        }
                        try {
                            field.setAccessible(true);
                            field.set(ret[i], serializer.deserialize(fieldName, deserialize));
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            field.setAccessible(true);
                            if (field.getType().isEnum()) {
                                field.set(ret[i], this.getEnum(field.getType(), fieldName)[i]);
                            } else if (Serializable.class.isAssignableFrom(field.getType()) && ColumnType.getType(field.getType()) == ColumnType.NONE) {
                                field.set(ret[i], this.getBlob(fieldName)[i]);
                            } else {
                                field.set(ret[i], this.getObject(fieldName)[i]);
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
            ++i;
        }
        this.resultsClasses.put(clazz, ret);
        return ret;
    }

    public Object getFirstObjectFromType(Class<?> clazz) {
        return this.getObjectFromType(clazz)[0];
    }

    public <T extends Enum<T>> Object[] getEnum(Class<T> enumType, String col) {
        Object[] ret = new Object[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            ret[i] = col.matches("[^>]+>[^>]+") ? Enum.valueOf(enumType, this.getJSONObject(col.split(">")[0])[i].get(col.split(">", 2)[1]).toString()) : Enum.valueOf(enumType, this.getObject(col)[i].toString());
            ++i;
        }
        return ret;
    }

    public <T extends Enum<T>> T getFirstEnum(Class<T> enumType, String col) {
        return (T)((Enum)this.getEnum(enumType, col)[0]);
    }

    public void close() {
        try {
            this.rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean next() {
        ++this.index;
        return this.index != this.getSize();
    }

    public Object getCurrentObject(String col) {
        return this.getObject(col)[this.index];
    }

    public boolean getCurrentBoolean(String col) {
        return this.getBoolean(col)[this.index];
    }

    public String getCurrentString(String col) {
        return this.getString(col)[this.index];
    }

    public int getCurrentInt(String col) {
        return this.getInt(col)[this.index];
    }

    public double getCurrentDouble(String col) {
        return this.getDouble(col)[this.index];
    }

    public long getCurrentLong(String col) {
        return this.getLong(col)[this.index];
    }

    public Object getCurrentBlob(String col) {
        return this.getBlob(col)[this.index];
    }

    public Object getCurrentObjectFromType(Class<?> clazz) {
        return this.getObjectFromType(clazz)[this.index];
    }

    public JSONObject getCurrentJSONObject(String col) {
        return this.getJSONObject(col)[this.index];
    }

    public <T extends Enum<T>> T getCurrentEnum(Class<T> enumType, String col) {
        return (T)((Enum)this.getEnum(enumType, col)[this.index]);
    }
}

