/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.syntax;

import de.syranda.spidermysql.customclasses.ConnectionManager;
import de.syranda.spidermysql.customclasses.ConventionFormatter;
import de.syranda.spidermysql.customclasses.builder.ColumnType;
import de.syranda.spidermysql.customclasses.builder.Exclude;
import de.syranda.spidermysql.customclasses.builder.ExcludeField;
import de.syranda.spidermysql.customclasses.builder.ForeignKey;
import de.syranda.spidermysql.customclasses.builder.Key;
import de.syranda.spidermysql.customclasses.builder.MySQLClass;
import de.syranda.spidermysql.customclasses.table.ClassSerializer;
import de.syranda.spidermysql.customclasses.table.MySQLField;
import de.syranda.spidermysql.customclasses.table.TableClass;
import de.syranda.spidermysql.utils.ConfigValues;
import de.syranda.spidermysql.utils.Serializer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class MySQLTableSyntax {
    private String tableName;
    private String database;

    public MySQLTableSyntax(String tableName) {
        this.tableName = tableName;
        this.database = ConfigValues.MYSQL_DATABASE;
    }

    public MySQLTableSyntax(String tableName, String database) {
        this.tableName = tableName;
        this.database = database;
    }

    public MySQLTableSyntax(TableClass table) {
        this.tableName = table.getTableName();
        this.database = table.getDatabase();
    }

    public String insert(String values) {
        if (!MySQLTableSyntax.checkSyntax(values)) {
            ConnectionManager.handleException(new IllegalArgumentException("Syntax error for query " + values), false);
        }
        String query = "INSERT INTO " + this.getTarget() + " (" + MySQLTableSyntax.getEscapedKeyList(values, ",") + ") VALUES (" + MySQLTableSyntax.getEscapedValueList(values, ",") + ")";
        return query;
    }

    public String insertUpdate(String values) {
        if (!MySQLTableSyntax.checkSyntax(values)) {
            ConnectionManager.handleException(new IllegalArgumentException("Syntax error for query " + values), false);
        }
        String query = "INSERT INTO " + this.getTarget() + " (" + MySQLTableSyntax.getEscapedKeyList(values, ",") + ") VALUES (" + MySQLTableSyntax.getEscapedValueList(values, ",") + ") ON DUPLICATE KEY UPDATE " + MySQLTableSyntax.getEscapedKeyValueList(values, ",");
        return query;
    }

    public String insertIgnore(String values) {
        if (!MySQLTableSyntax.checkSyntax(values)) {
            ConnectionManager.handleException(new IllegalArgumentException("Syntax error for query " + values), false);
        }
        String query = "INSERT IGNORE INTO " + this.getTarget() + " (" + MySQLTableSyntax.getEscapedKeyList(values, ",") + ") VALUES (" + MySQLTableSyntax.getEscapedValueList(values, ",") + ")";
        return query;
    }

    public String insert(Object clazz, String add) {
        return this.insert(this.getSpiderList(clazz, add));
    }

    public String insert(Object clazz) {
        return this.insert(clazz, "");
    }

    public String insertUpdate(Object clazz, String add) {
        return this.insertUpdate(this.getSpiderList(clazz, add));
    }

    public String insertUpdate(Object clazz) {
        return this.insertUpdate(clazz, "");
    }

    public String insertIgnore(Object clazz, String add) {
        return this.insertIgnore(this.getSpiderList(clazz, add));
    }

    public String insertIgnore(Object clazz) {
        return this.insertIgnore(clazz, "");
    }

    public String get(String what, String where) {
        if (!MySQLTableSyntax.checkListSyntax(what) && !what.equalsIgnoreCase("*")) {
            throw new IllegalArgumentException("Syntax error for query " + what);
        }
        if (!MySQLTableSyntax.checkSyntax(where)) {
            throw new IllegalArgumentException("Syntax error for query " + where);
        }
        String query = "SELECT " + MySQLTableSyntax.getEscapedKeyList(what, ",") + " FROM " + this.getTarget() + " WHERE " + MySQLTableSyntax.getEscapedKeyValueList(where, "AND");
        return query;
    }

    public String get(String where) {
        if (!MySQLTableSyntax.checkSyntax(where)) {
            throw new IllegalArgumentException("Syntax error for query " + where);
        }
        String query = "SELECT * FROM " + this.getTarget() + " WHERE " + MySQLTableSyntax.getEscapedKeyValueList(where, "AND");
        return query;
    }

    public String update(String what, String where) {
        if (!MySQLTableSyntax.checkSyntax(what)) {
            throw new IllegalArgumentException("Syntax error for query " + what);
        }
        if (!MySQLTableSyntax.checkSyntax(where) && !where.equals("")) {
            throw new IllegalArgumentException("Syntax error for query " + where);
        }
        String query = "UPDATE " + this.getTarget() + " SET " + MySQLTableSyntax.getEscapedKeyValueList(what, ",");
        if (!where.equals("")) {
            query = String.valueOf(query) + " WHERE " + MySQLTableSyntax.getEscapedKeyValueList(where, "AND");
        }
        return query;
    }

    public String update(String what) {
        if (!MySQLTableSyntax.checkSyntax(what)) {
            throw new IllegalArgumentException("Syntax error for query " + what);
        }
        return this.update(what, "");
    }

    public String delete(String where) {
        if (!MySQLTableSyntax.checkSyntax(where)) {
            throw new IllegalArgumentException("Syntax error for query " + where);
        }
        String query = "DELETE FROM " + this.getTarget() + " WHERE " + MySQLTableSyntax.getEscapedKeyValueList(where, "AND");
        return query;
    }

    public String get() {
        return "SELECT * FROM " + this.getTarget();
    }

    public String truncate() {
        String query = "TRUNCATE " + this.getTarget();
        return query;
    }

    public String getTarget() {
        return this.database == null ? "`" + this.tableName + "`" : "`" + this.database + "`.`" + this.tableName + "`";
    }

    public String getDatabase() {
        return this.database;
    }

    public String changeColumn(String field, MySQLField newField) {
        String query = "ALTER TABLE " + this.getTarget() + " CHANGE COLUMN `" + field + "` `" + newField.getFieldName() + "` " + newField.getType() + (newField.getLength() != 0 ? "(" + newField.getLength() + ")" : "");
        return query;
    }

    public String setColumnDefault(String field, Object newDefault) {
        String query = "ALTER TABLE " + this.getTarget() + " ALTER COLUMN `" + field + "`";
        if (newDefault == null) {
            query = String.valueOf(query) + " DROP DEFAULT";
        } else {
            try {
                int defaultValue = Integer.parseInt(newDefault.toString());
                query = String.valueOf(query) + " SET DEFAULT " + defaultValue;
            }
            catch (Exception e) {
                query = String.valueOf(query) + " SET DEFAULT '" + newDefault.toString() + "'";
            }
        }
        return query;
    }

    public String changeColumnType(MySQLField field) {
        String query = "ALTER TABLE " + this.getTarget() + " MODIFY COLUMN `" + field.getFieldName() + "` " + field.getType() + (field.getLength() != 0 ? "(" + field.getLength() + ")" : "");
        if (field.isAutoIncrement()) {
            query = String.valueOf(query) + " AUTO_INCREMENT";
        }
        return query;
    }

    public String addField(MySQLField field) {
        String query = "ALTER TABLE " + this.getTarget() + " ADD COLUMN `" + field.getFieldName() + "` " + field.getType() + (field.getLength() != 0 ? "(" + field.getLength() + ")" : "");
        if (field.allowNull()) {
            query = String.valueOf(query) + " NOT NULL";
        }
        if (field.getDefaultValue() != null) {
            try {
                int defaultValue = Integer.parseInt(field.getDefaultValue().toString());
                query = String.valueOf(query) + " DEFAULT " + defaultValue;
            }
            catch (Exception e) {
                query = String.valueOf(query) + " DEFAULT '" + field.getDefaultValue().toString() + "'";
            }
        }
        if (field.isAutoIncrement()) {
            query = String.valueOf(query) + " AUTO_INCREMENT";
        }
        return query;
    }

    public String dropColumn(String field) {
        String query = "ALTER TABLE " + this.getTarget() + " DROP COLUMN `" + field + "`";
        return query;
    }

    public String dropPrimaryKey() {
        String query = "ALTER TABLE " + this.getTarget() + " DROP PRIMARY KEY";
        return query;
    }

    public String dropKey(String key) {
        String query = "ALTER TABLE " + this.getTarget() + " DROP KEY `" + key + "`";
        return query;
    }

    public String dropForeignKey(String foreignKey) {
        String query = "ALTER TABLE " + this.getTarget() + " DROP FOREIGN KEY `" + foreignKey + "`";
        return query;
    }

    public String addKey(Key key) {
        String query = "ALTER TABLE " + this.getTarget() + " ADD ";
        String keys = "";
        int i = 0;
        while (i < key.getColumns().length) {
            keys = String.valueOf(keys) + (i == 0 ? "`" + key.getColumns()[i] + "`" : ", `" + key.getColumns()[i] + "`");
            ++i;
        }
        switch (key.getKeyType()) {
            case PRIMARY: {
                query = String.valueOf(query) + "PRIMARY KEY (" + keys + ")";
                break;
            }
            case UNIQUE: {
                query = String.valueOf(query) + "UNIQUE KEY `" + key.getKeyName() + "` (" + keys + ")";
                break;
            }
        }
        return query;
    }

    public String addForeignKey(ForeignKey key) {
        String query = "ALTER TABLE " + this.getTarget() + " ADD ";
        String targetC = "";
        int ii = 0;
        while (ii < key.getTargetColumns().length) {
            targetC = String.valueOf(targetC) + (ii == 0 ? "`" + key.getTargetColumns()[ii] + "`" : ", `" + key.getTargetColumns()[ii] + "`");
            ++ii;
        }
        String referenceC = "";
        int ii2 = 0;
        while (ii2 < key.getReferenceColumns().length) {
            referenceC = String.valueOf(referenceC) + (ii2 == 0 ? "`" + key.getReferenceColumns()[ii2] + "`" : ", `" + key.getReferenceColumns()[ii2] + "`");
            ++ii2;
        }
        query = String.valueOf(query) + "CONSTRAINT `" + key.getKeyName() + "` FOREIGN KEY (" + targetC + ") REFERENCES `" + key.getRefrenceTable() + "` (" + referenceC + ") ON DELETE " + key.getOnDelete().getAction() + " ON UPDATE " + key.getOnUpdate().getAction();
        return query;
    }

    public String drop() {
        String query = "DROP TABLE IF EXISTS " + this.getTarget();
        return query;
    }

    public String describe() {
        String query = "DESCRIBE " + this.getTarget();
        return query;
    }

    public String showKeys() {
        String query = "SELECT `information_schema`.`KEY_COLUMN_USAGE`.`CONSTRAINT_NAME`,`information_schema`.`KEY_COLUMN_USAGE`.`COLUMN_NAME`,`information_schema`.`KEY_COLUMN_USAGE`.`REFERENCED_TABLE_NAME`,`information_schema`.`KEY_COLUMN_USAGE`.`REFERENCED_COLUMN_NAME`,`information_schema`.`REFERENTIAL_CONSTRAINTS`.`UPDATE_RULE`,`information_schema`.`REFERENTIAL_CONSTRAINTS`.`DELETE_RULE` FROM `information_schema`.`KEY_COLUMN_USAGE`LEFT JOIN `information_schema`.`REFERENTIAL_CONSTRAINTS` ON `information_schema`.`REFERENTIAL_CONSTRAINTS`.`CONSTRAINT_NAME` = `information_schema`.`KEY_COLUMN_USAGE`.`CONSTRAINT_NAME` WHERE `information_schema`.`KEY_COLUMN_USAGE`.`TABLE_NAME` = '" + this.tableName + "' AND TABLE_SCHEMA = '" + this.database + "' " + "GROUP BY `information_schema`.`KEY_COLUMN_USAGE`.`CONSTRAINT_NAME`, `information_schema`.`KEY_COLUMN_USAGE`.`COLUMN_NAME`";
        return query;
    }

    private static boolean checkListSyntax(String raw) {
        return raw.matches("^[^;]+(;[^;])*");
    }

    private static boolean checkSyntax(String raw) {
        return raw.matches("^[^;:]+:[^;]+(;[^;:]+:[^;]+)*");
    }

    private static String getEscapedKeyList(String raw, String connector) {
        String ret = "";
        int i = 0;
        while (i < raw.split(";").length) {
            ret = String.valueOf(ret) + (i == 0 ? "`" + raw.split(";")[i].split(":", 2)[0] + "`" : " " + connector + " " + "`" + raw.split(";")[i].split(":", 2)[0] + "`");
            ++i;
        }
        if (ret.contains(">")) {
            ret = String.valueOf(ret.split(">")[0]) + "`";
        }
        return ret;
    }

    private static String getEscapedValueList(String raw, String connector) {
        String ret = "";
        HashMap<String, JSONObject> jsons = new HashMap<String, JSONObject>();
        int i = 0;
        while (i < raw.split(";").length) {
            String key = raw.split(";")[i].split(":", 2)[0];
            String value = raw.split(";")[i].split(":", 2)[1];
            if (key.matches("[^>]+>[^>]+")) {
                String subkey = key.split(">")[0];
                JSONObject json = jsons.containsKey(subkey) ? (JSONObject)jsons.get(subkey) : new JSONObject();
                json.put(key.split(">", 2)[1], value);
                jsons.put(subkey, json);
            } else {
                String pre = "";
                if (value.matches("^(OLD|NEW)(\\.{1})\\w([^\\.]*)")) {
                    pre = String.valueOf(value.split("\\.")[0]) + ".";
                    value = value.split("\\.")[1];
                    ret = String.valueOf(ret) + (i == 0 ? String.valueOf(pre) + "`" + value + "`" : " " + connector + " " + pre + "`" + value + "`");
                } else {
                    try {
                        int intValue = Integer.parseInt(value);
                        ret = String.valueOf(ret) + (i == 0 ? Integer.valueOf(intValue) : String.valueOf(connector) + intValue);
                    }
                    catch (Exception e) {
                        ret = String.valueOf(ret) + (i == 0 ? "'" + value + "'" : " " + connector + " " + "'" + value + "'");
                    }
                }
            }
            ++i;
        }
        for (Map.Entry json : jsons.entrySet()) {
            ret = String.valueOf(ret) + (ret.equals("") ? "'" + ((JSONObject)json.getValue()).toJSONString() + "'" : " " + connector + " '" + ((JSONObject)json.getValue()).toJSONString() + "'");
        }
        return ret;
    }

    private static String getEscapedKeyValueList(String raw, String connector) {
        String ret = "";
        HashMap<String, JSONObject> jsons = new HashMap<String, JSONObject>();
        int i = 0;
        while (i < raw.split(";").length) {
            String key = raw.split(";")[i].split(":", 2)[0];
            String value = raw.split(";")[i].split(":", 2)[1];
            if (key.matches("[^>]+>[^>]+")) {
                String subkey = key.split(">")[0];
                JSONObject json = jsons.containsKey(subkey) ? (JSONObject)jsons.get(subkey) : new JSONObject();
                json.put(key.split(">", 2)[1], value);
                jsons.put(subkey, json);
            } else {
                String pre = "";
                if (value.matches("^(OLD|NEW)(\\.{1})\\w([^\\.]*)")) {
                    pre = String.valueOf(value.split("\\.")[0]) + ".";
                    value = value.split("\\.")[1];
                    ret = String.valueOf(ret) + (i == 0 ? "`" + key + "`=" + pre + "`" + value + "`" : " " + connector + " `" + key + "`=" + pre + "`" + value + "`");
                } else {
                    try {
                        int intValue = Integer.parseInt(value);
                        ret = String.valueOf(ret) + (i == 0 ? "`" + key + "`=" + intValue : " " + connector + " " + "`" + key + "`=" + intValue);
                    }
                    catch (Exception e) {
                        ret = String.valueOf(ret) + (i == 0 ? "`" + key + "`='" + value + "'" : " " + connector + " " + "`" + key + "`='" + value + "'");
                    }
                }
            }
            ++i;
        }
        for (Map.Entry json : jsons.entrySet()) {
            ret = String.valueOf(ret) + (ret.equals("") ? "`" + (String)json.getKey() + "`='" + ((JSONObject)json.getValue()).toJSONString() + "'" : " " + connector + " `" + (String)json.getKey() + "`='" + ((JSONObject)json.getValue()).toJSONString() + "'");
        }
        return ret;
    }

    private String getSpiderList(Object clazz, String add) {
        String list = "";
        boolean first = true;
        boolean adjust = clazz.getClass().isAnnotationPresent(MySQLClass.class) ? clazz.getClass().getAnnotation(MySQLClass.class).adjustFields() : false;
        int i = 0;
        while (i < clazz.getClass().getDeclaredFields().length) {
            block14: {
                block13: {
                    Field field = clazz.getClass().getDeclaredFields()[i];
                    field.setAccessible(true);
                    if (!field.isAnnotationPresent(de.syranda.spidermysql.customclasses.builder.MySQLField.class) && !clazz.getClass().isAnnotationPresent(MySQLClass.class) || field.isAnnotationPresent(Exclude.class) || Modifier.isStatic(field.getModifiers())) break block14;
                    String fieldName = adjust ? ConventionFormatter.getMySQLName(field.getName()) : field.getName();
                    try {
                        block15: {
                            if (!ClassSerializer.hasSerializer(field.getType())) break block15;
                            int index = 0;
                            while (index < ClassSerializer.getSerializer(field.getType()).serializeObject(fieldName, field.get(clazz)).size()) {
                                block17: {
                                    Map.Entry entry;
                                    block16: {
                                        entry = (Map.Entry)ClassSerializer.getSerializer(field.getType()).serializeObject(fieldName, field.get(clazz)).entrySet().toArray()[index];
                                        if (!field.isAnnotationPresent(ExcludeField.class)) break block16;
                                        boolean con = true;
                                        String[] stringArray = field.getAnnotation(ExcludeField.class).fields();
                                        int n = stringArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String exField = stringArray[n2];
                                            if (((String)entry.getKey()).equals(exField)) {
                                                con = false;
                                            }
                                            ++n2;
                                        }
                                        if (!con) break block17;
                                    }
                                    if (first) {
                                        list = String.valueOf(list) + (String)entry.getKey() + ":" + entry.getValue();
                                        first = false;
                                    } else {
                                        list = String.valueOf(list) + ";" + (String)entry.getKey() + ":" + entry.getValue();
                                    }
                                }
                                ++index;
                            }
                            break block13;
                        }
                        list = field.getType().isEnum() && ColumnType.getType(field.getType()) == ColumnType.NONE ? String.valueOf(list) + (first ? String.valueOf(fieldName) + ":" + ((Enum)field.get(clazz)).name() : ";" + fieldName + ":" + ((Enum)field.get(clazz)).name()) : (Serializable.class.isAssignableFrom(field.getType()) && ColumnType.getType(field.getType()) == ColumnType.NONE ? String.valueOf(list) + (first ? String.valueOf(fieldName) + ":" + Serializer.serialize(field.get(clazz)) : ";" + fieldName + ":" + Serializer.serialize(field.get(clazz))) : String.valueOf(list) + (first ? String.valueOf(fieldName) + ":" + field.get(clazz).toString() : ";" + fieldName + ":" + field.get(clazz).toString()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                first = false;
            }
            ++i;
        }
        if (!add.equals("")) {
            list = String.valueOf(list) + ";" + add;
        }
        return list;
    }
}

