/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.registry.patcher;

import de.syranda.spidermysql.customclasses.registry.patcher.PatcherValue;
import de.syranda.spidermysql.customclasses.table.TableClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class TablePatcher {
    private String name;
    private String description;
    private HashMap<String, String> alter = new HashMap();
    private List<PatcherValue> valueList = new ArrayList<PatcherValue>();

    public TablePatcher(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void addAlter(String database, String ram) {
        this.alter.put(database, ram);
    }

    protected final HashMap<String, String> getAlter() {
        return this.alter;
    }

    protected final void addValue(PatcherValue value) {
        this.valueList.add(value);
    }

    public final List<PatcherValue> getValueList() {
        return this.valueList;
    }

    protected final PatcherValue getValue(String name) {
        for (PatcherValue pValue : this.valueList) {
            if (!pValue.getName().equals(name)) continue;
            return pValue;
        }
        return null;
    }

    public final void setValue(String name, Object value) {
        for (PatcherValue pValue : this.valueList) {
            if (!pValue.getName().equals(name)) continue;
            pValue.setValue(value);
        }
    }

    public final boolean isAccepting(String name) {
        for (PatcherValue pValue : this.valueList) {
            if (!pValue.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean patch(TableClass var1);
}

