/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.registry.patcher;

import de.syranda.spidermysql.customclasses.builder.ForeignKey;
import de.syranda.spidermysql.customclasses.builder.Key;
import de.syranda.spidermysql.customclasses.registry.TableInformation;
import de.syranda.spidermysql.customclasses.registry.TableRegistry;
import de.syranda.spidermysql.customclasses.registry.comparison.ComparisonInformation;
import de.syranda.spidermysql.customclasses.registry.comparison.SingleComparison;
import de.syranda.spidermysql.customclasses.registry.patcher.PatcherValue;
import de.syranda.spidermysql.customclasses.registry.patcher.TablePatcher;
import de.syranda.spidermysql.customclasses.table.MySQLField;
import de.syranda.spidermysql.customclasses.table.RecordResult;
import de.syranda.spidermysql.customclasses.table.TableClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DefaultPatcher
extends TablePatcher {
    public DefaultPatcher() {
        super("default", "SpiderMySQL - Default patcher | Suitable for all patches");
        this.addValue(new PatcherValue("soft", true));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean patch(TableClass table) {
        boolean soft = this.getValue("soft").asBoolean();
        ComparisonInformation com = table.compare();
        TableInformation ram = TableRegistry.getRamTable(table);
        TableInformation database = TableRegistry.getDatabaseTable(table);
        if (soft) {
            for (Map.Entry<String, String> entry : this.getAlter().entrySet()) {
                table.changeColumn(entry.getValue(), ram.getMySQLField(entry.getKey()));
            }
            for (Map.Entry<String, Object> entry : com.getFieldComparison().getDifferences().entrySet()) {
                if (((SingleComparison)entry.getValue()).isInDatabase()) continue;
                table.addField((MySQLField)((SingleComparison)entry.getValue()).getRamValue());
            }
            for (Map.Entry<String, Object> entry : com.getKeyComparison().getDifferences().entrySet()) {
                if (((SingleComparison)entry.getValue()).isInDatabase()) continue;
                table.addKey((Key)((SingleComparison)entry.getValue()).getRamValue());
            }
            for (Map.Entry<String, Object> entry : com.getForeignKeyComparison().getDifferences().entrySet()) {
                if (((SingleComparison)entry.getValue()).isInDatabase()) continue;
                table.addForeignKey((ForeignKey)((SingleComparison)entry.getValue()).getRamValue());
            }
        } else {
            void var8_17;
            ArrayList arrayList = new ArrayList();
            RecordResult dataResult = table.get();
            boolean bl = false;
            while (var8_17 < dataResult.getSize()) {
                HashMap<String, Object> add = new HashMap<String, Object>();
                for (MySQLField field : database.getFieldList()) {
                    if (this.getAlter().containsKey(field.getFieldName())) {
                        add.put(this.getAlter().get(field.getFieldName()), dataResult.getObject(field.getFieldName())[var8_17]);
                        continue;
                    }
                    if (ram.getMySQLField(field.getFieldName()) == null) continue;
                    add.put(field.getFieldName(), dataResult.getObject(field.getFieldName())[var8_17]);
                }
                arrayList.add(add);
                ++var8_17;
            }
            table.drop();
            ram.rebuild();
            for (HashMap hashMap : arrayList) {
                String insertData = "";
                int i2 = 0;
                while (i2 < hashMap.size()) {
                    Map.Entry set = (Map.Entry)hashMap.entrySet().toArray()[i2];
                    String key = ((String)set.getKey()).toString();
                    if (ram.getMySQLField(key) != null) {
                        Object value = set.getValue();
                        insertData = String.valueOf(insertData) + (i2 == 0 ? String.valueOf(key) + ":" + value : ";" + key + ":" + value);
                    }
                    ++i2;
                }
                table.insert(insertData);
            }
        }
        return true;
    }
}

