/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.registry.comparison;

import de.syranda.spidermysql.customclasses.builder.ForeignKey;
import de.syranda.spidermysql.customclasses.registry.TableInformation;
import de.syranda.spidermysql.customclasses.registry.comparison.SingleComparison;
import java.util.Arrays;
import java.util.HashMap;

public class ForeignKeyComparison {
    private HashMap<String, SingleComparison<ForeignKey>> differences = new HashMap();

    public ForeignKeyComparison(TableInformation ram, TableInformation database) {
        for (ForeignKey fKey : ram.getForeignKeyList()) {
            ForeignKey comp = database.getForeignKey(fKey.getKeyName());
            if (comp == null) {
                this.differences.put(fKey.getKeyName(), new SingleComparison<Object>(fKey, null));
                continue;
            }
            if (fKey.getOnDelete() == comp.getOnDelete() && fKey.getOnUpdate() == comp.getOnUpdate() && Arrays.equals(fKey.getReferenceColumns(), comp.getReferenceColumns()) && Arrays.equals(fKey.getTargetColumns(), comp.getTargetColumns())) continue;
            this.differences.put(fKey.getKeyName(), new SingleComparison<ForeignKey>(fKey, comp));
        }
        for (ForeignKey comp : database.getForeignKeyList()) {
            if (ram.getForeignKey(comp.getKeyName()) != null) continue;
            this.differences.put(comp.getKeyName(), new SingleComparison<ForeignKey>(null, comp));
        }
    }

    public boolean hasDifferences() {
        return !this.differences.isEmpty();
    }

    public HashMap<String, SingleComparison<ForeignKey>> getDifferences() {
        return this.differences;
    }
}

