/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.registry.comparison;

import de.syranda.spidermysql.customclasses.registry.TableInformation;
import de.syranda.spidermysql.customclasses.registry.comparison.SingleComparison;
import de.syranda.spidermysql.customclasses.table.MySQLField;
import java.util.HashMap;

public class FieldComparison {
    private HashMap<String, SingleComparison<MySQLField>> differences = new HashMap();

    public FieldComparison(TableInformation ram, TableInformation database) {
        for (MySQLField field : ram.getFieldList()) {
            MySQLField comp = database.getMySQLField(field.getFieldName());
            if (comp == null) {
                this.differences.put(field.getFieldName(), new SingleComparison<Object>(field, null));
                continue;
            }
            if (field.getType().equals(comp.getType()) && field.getLength() == comp.getLength() && field.isAutoIncrement() == comp.isAutoIncrement() && field.getLength() == comp.getLength() && field.getDefaultValue() == comp.getDefaultValue()) continue;
            this.differences.put(field.getFieldName(), new SingleComparison<MySQLField>(field, comp));
        }
        for (MySQLField comp : database.getFieldList()) {
            if (ram.getMySQLField(comp.getFieldName()) != null) continue;
            this.differences.put(comp.getFieldName(), new SingleComparison<MySQLField>(null, comp));
        }
    }

    public boolean hasDifferences() {
        return !this.differences.isEmpty();
    }

    public HashMap<String, SingleComparison<MySQLField>> getDifferences() {
        return this.differences;
    }
}

